
console.log('CME-----------------------> jounral-manager');

// TODO : not set as global
const macroOptionKeyMap = new Map();

// Pinned character Pannel
const characterPannel = createCustomObject('div');
characterPannel.addClass('character-pannel');
$('#rightsidebar').append(characterPannel);

// Pinned character display toggle button
const characterSheetButton = createCustomObject('div');
characterSheetButton.addClass('character-sheet-button');
characterSheetButton.addClass('ripple');
$(document.body).append(characterSheetButton);
const characterSheetButtonIcon = createCustomObject('div');
characterSheetButtonIcon.addClass('character-sheet-button-icon');
characterSheetButton.append(characterSheetButtonIcon);
characterSheetButton.click(() => {
	console.log('characterSheetButton CLICK !!!');
	if (!characterPannel.hasClass('data')) {
		showPinnedCharSheet(false);
		$('#textchat-input').css('display', 'none');
		var index = $('#rightsidebar > ul.tabmenu a[href="#journal"]').parent().index();
		$('#rightsidebar').tabs({
		  active: index
		});
	} else {
		showPinnedCharSheet(!characterPannel.hasClass('on'));	
	}
});
// Hidde pinned character upon rightsidebar tab button click
$(document.body).find('#rightsidebar > ul.tabmenu > li').each(function() {
	var tab = $(this);
	tab.click(function() {
		showPinnedCharSheet(false);
		if (tab.find('a[href="#textchat"]').length > 0) {
			$('#textchat-input').css('display', 'block');
		} else {
			$('#textchat-input').css('display', 'none');
		}
	});
});

function showPinnedCharSheet(display) {
	console.log('showPinnedCharSheet :: ' + display);
	if (display) {
		$('#rightsidebar .character-pannel').addClass('on');
		$('#character-sheet-button').addClass('on');
		$('#textchat-input').addClass('hidden-pane');
	} else {
		$('#rightsidebar .character-pannel').removeClass('on');
		$('#character-sheet-button').removeClass('on');
		$('#textchat-input').removeClass('hidden-pane');
	}
}

// Add pinn action button into each character sheet dialog
// --1 : Observer adding pinn button into new created dialogs
new MutationObserver(function (mutationsList) {
	for(var mutation of mutationsList) {
		if (mutation.type == 'childList') {
			// parse new node added into the chat
			for (var node of mutation.addedNodes) {
				// check init to avoid auto-play media from old msg
				if (node.nodeType === Node.ELEMENT_NODE) {
					var myNode = $(node);
					if (myNode.hasClass('ui-dialog')) {
						initPinnButton(myNode, 0);
					}
				}
			}
		}
	}
}).observe(document.body, {
	childList: true
});
// -- 2: Add pinn action button into existing dialogs
$(document.body).find('.ui-dialog').each(function() {
	if ($(this).has('.sheet-coc7e')) {
		addPinnButton($(this));
	}
});

function initPinnButton(root, nbOfAttempt) {
	if (nbOfAttempt >= 5) {
		return;
	}
	if (root.has('.characterviewer')) {
		addPinnButton(root);
	} else {
		setTimeout(initPinnButton, 400, root, nbOfAttempt+1);
	}
}

function addPinnButton(root) {
	root.find('.characterviewer').each(function() {
		var pinnBtn = createCustomObject('div');
		pinnBtn.addClass('character-sheet-button');
		pinnBtn.addClass('ripple');
		var characterSheetButtonIcon = createCustomObject('div');
		characterSheetButtonIcon.addClass('character-sheet-button-icon');
		pinnBtn.append(characterSheetButtonIcon);
		root.append(pinnBtn);
		pinnBtn.click(function() {
			if(root.has('.sheet-pc')) {
				// Sheet PJ
				pinnSheetPJ(root);
			} else if(root.has('.sheet-npc')) {
				// Sheet PNJ
				// TODO ...
			}
		});
	});
}

function pinnSheetPJ(root) {
	var id = root.find('.dialog.characterdialog').first().attr('data-characterid');
	var avatar = root.find('.avatar img').first();
	var sheet = root.find('.sheet-pc').first();
	
	// macro key values
	const macroAttrKeyMap = new Map();
	const charNameKey = 'character_name';
	const rollDifficultyKey = 'dice_toggle';
	const rollWhisperKey = 'roll_whisper';
	// -- Global parameters
	root.find(".sheet-coc7e > input[name^='attr_']").each(function() {
		macroAttrKeyMap.set($(this).attr('name').substring(5), $(this).attr('value'))
	});
	// -- Attributes & skills values
	sheet.find("div.sheet-edit-hide span[name^='attr_']").each(function() {
		macroAttrKeyMap.set($(this).attr('name').substring(5), $(this).html())
	});
	// -- Roll options (variable)
	sheet.find(".sheet-checkmark-item input:checked[name^='attr_"+rollDifficultyKey+"']").each(function() {
		macroOptionKeyMap.set($(this).attr('name').substring(5), $(this).attr('value'))
	});
	macroOptionKeyMap.set(rollWhisperKey, '');
	sheet.find(".sheet-checkmark-item input:checked[name='"+rollWhisperKey+"']").each(function() {
		macroOptionKeyMap.set($(this).attr('name').substring(5), $(this).html())
	});
	
	// clear previous data
	characterPannel.children().remove();
		
	// drop-out sheet button
	const characterDragOutBtn = createCustomObject('div');
	characterDragOutBtn.addClass('drop-out');
	characterPannel.append(characterDragOutBtn);
		
	// image
	const characterAvatarPane = createCustomObject('div');
	characterAvatarPane.addClass('character-avatar-pane');
	if (avatar && avatar.attr('src')) {
		var avatarPJ = avatar.clone(true);
		avatarPJ.attr('data-characterid', id);
		avatarPJ.addClass('open-dialog');
		
		characterAvatarPane.attr('data-characterid', id);
		characterAvatarPane.addClass('open-dialog');
		
		characterAvatarPane.append(avatarPJ);
		characterPannel.addClass('data');
	}
	characterPannel.append(characterAvatarPane);
	
	// Character Name
	const characterTitlePane = createCustomObject('div');
	characterTitlePane.addClass('character-title-pane');
	characterTitlePane.html(macroAttrKeyMap.get(charNameKey));
	characterPannel.append(characterTitlePane);
	
	// sheet-character-attributes
	const characterGlobalAttrPane = createCustomObject('div');
	characterGlobalAttrPane.addClass('character-global-attr-pane');
	characterGlobalAttrPane.addClass('character-sub-pane');
	characterPannel.append(characterGlobalAttrPane);
	
	const characterAttributesPane = createCustomObject('div');
	characterAttributesPane.addClass('character-attr-pane');
	sheet.find('.sheet-character-attributes .sheet-attribute-display').each(function() {
		if (!$(this).hasClass('sheet-edit-show')) {
			var clone = $(this).clone(true);
			clone.addClass('short-attr');
			clone.find('.sheet-edit-show').remove();
			// get translated name + set short name
			var attrName = null;
			clone.find('strong').each(function() {
				attrName = $(this).html();
				var shortName = $(this).html().substring(0,3);
				$(this).html(shortName);
			});
			clone.attr('title', attrName);
			// action
			clone.find('button').each(function () {
				var macro = replaceMacroTitle($(this).attr('value'), attrName);
				macro = replaceParameters(macro, macroAttrKeyMap);
				$(this).attr('data', macro);
				$(this).addClass('macro');
			});
			clone.appendTo(characterAttributesPane);
		}
	});
	characterGlobalAttrPane.append(characterAttributesPane);
	
	// sheet-character-secondary-attributes
	const characterSecondaryAttrPane = createCustomObject('div');
	characterSecondaryAttrPane.addClass('character-sec-attr-pane');
	sheet.find('.sheet-character-secondary-attributes .sheet-attribute-display').each(function() {
		if (!$(this).hasClass('sheet-edit-show')) {
			var clone = $(this).clone(true);
			clone.addClass('short-sec-attr');
			clone.find('.sheet-edit-show').remove();
			// get translated name
			var attrName = null;
			var dataName = '';
			clone.find('.sheet-minmax-display > strong[data-i18n]').each(function () {
				attrName = $(this).html();
				dataName = $(this).attr('data-i18n').replace(' ','-');
				$(this).addClass(dataName);
				$(this).html('');
			});
			clone.attr('title', attrName);
			clone.addClass(dataName);
			// action
			clone.find('.sheet-minmax-display > button').each(function () {
				var macro = replaceMacroTitle($(this).attr('value'), attrName);
				macro = replaceParameters(macro, macroAttrKeyMap);
				$(this).attr('data', macro);
				$(this).addClass('macro');
			});
			clone.appendTo(characterSecondaryAttrPane);
		}
	});
	characterGlobalAttrPane.append(characterSecondaryAttrPane);
	
	// sheet-skills
	const characterSkillPane = createCustomObject('div', 'character-skill-pane');
	characterSkillPane.addClass('character-skill-pane');
	characterSkillPane.addClass('character-sub-pane');
	sheet.find('.sheet-skills .sheet-skill-display-wrapper:not(.sheet-edit-show)').each(function() {
		var skillName = null;
		// get translated name (regular skill)
		$(this).find('.sheet-skill-display-title').each(function() {
			skillName = $(this).html();
			console.log('skillName ----------- ' + skillName);
		});
		// get translated name (custom skill)
		$(this).find('span[name="attr_name"]').each(function() {
			skillName = $(this).html();
			console.log('skillName ------------!!! ' + skillName);
		});
		// no name => do nothing
		if(skillName == null || !skillName) {
			return;
		}
		// get custom skill case value
		$(this).find('span[name="attr_value"]').each(function() {
			console.log('attr_value ------------!!! ' + $(this).html());
			macroAttrKeyMap.set('value', $(this).html());
		});
		var clone = $(this).clone(true);
		clone.find('.sheet-edit-show').remove();
		// action
		clone.find('button').each(function () {
			var macro = replaceMacroTitle($(this).attr('value'), skillName);
			macro = replaceParameters(macro, macroAttrKeyMap);
			$(this).attr('data', macro);
			$(this).addClass('macro');
		});
		clone.appendTo(characterSkillPane);
	});
	characterPannel.append(characterSkillPane);
	
	// sheet-toggle-roll
	const characterRollOptionPane = createCustomObject('div');
	characterRollOptionPane.addClass('character-roll-option-pane');
	sheet.find('.sheet-toggle-roll .sheet-checkmark label').each(function() {
		if (sheet.find)
		var clone = $(this).clone(true);
		// action
		clone.find('input').each(function () {
			$(this).addClass('macro-option');
		});
		clone.appendTo(characterRollOptionPane);
	});
	characterPannel.append(characterRollOptionPane);
	
	// display pinned sheet
	showPinnedCharSheet(true);
}

function computeMacro(str, options) {
	// set option values
	var value = replaceParameters(str, options);
	// eval expressions
	value = value.replace(/\[\[([a-zA-Z0-9\/\*\-\+\(\)]+)\]\]/g, function(_,k){
		var res = '[['+eval('Math.'+k)+']]';
		return res;
	});
	return value;
}
function replaceParameters(str, parameters) {
	return str.replace(/@{(\w+)}/g, function(_,k){
		return parameters.get(k) == null ? ('@{'+k+'}') : parameters.get(k);
	});
}
function replaceMacroTitle(str, value) {
	return str.replace(/\{\{title=([@\{\}\w+ ]+)\}\}/g, function(_,k){
		console.log('REPLACE::' + k + ' by ' + value);
		return '{{title='+value+'}}';
	});
}

// global click listener
function actionPerform(event) {
	var target = $(event.target);
	if(target.hasClass('macro')) {
		// launch macro
		showPinnedCharSheet(false);
		sendMsgByChat(computeMacro(target.attr('data'), macroOptionKeyMap), true);
	} else if(target.hasClass('macro-option')) {
		// change macro option
		macroOptionKeyMap.set(rollDifficultyKey, target.attr('value'));
	} else if(target.hasClass('open-dialog')) {
		// open dialog source
		var id = target.attr('data-characterid');
		openDialogSource(id);
	} else if(target.hasClass('drop-out')) {
		var miniDialog = createMiniSheetDialog(target.parent());
		$(document.body).append(miniDialog);
	} else if(target.hasClass('put-to-hand')) {
		// put sheet to hand
		var id = target.attr('data-characterid');
		var imageURL = target.attr('src');
		if(imageURL == null) {
			target.find('*[src]').each(function() {
				imageURL = $(this).attr('src');
			});
		}
		putInHand(imageURL, function() {
			openDialogSource(id);
		});
	}
}
characterPannel.click(actionPerform);

function createMiniSheetDialog(sheetSrc) {
	// create sheet as min-dialog
	var miniDialog = createCustomObject('div');
	miniDialog.addClass('character-pannel');
	miniDialog.addClass('mini-dialog');
	miniDialog.css('top', '200px');
	miniDialog.css('left', '200px');

	var id = sheetSrc.find('*[data-characterid]').first().attr('data-characterid');

	// -- min-dialog: global attributes pane
	sheetSrc.find('.character-global-attr-pane').each(function() {
		var miniMainAttr = $(this).clone(true);
		var miniCloseBtn = createCustomObject('div');
		miniCloseBtn.addClass('close');
		miniCloseBtn.click(function() {
			// close mini dialog
			miniDialog.remove();
		});
		miniMainAttr.append(miniCloseBtn);
		miniDialog.append(miniMainAttr);
	});

	// -- min-dialog: avatar pane
	sheetSrc.find('.character-avatar-pane').each(function() {
		var miniAvatar = $(this).clone(true);
		miniAvatar.removeClass('open-dialog');
		miniAvatarImg = createCustomObject('div');
		miniAvatarImg.addClass('image');
		miniAvatar.find('img').each(function() {
			miniAvatarImg.css('background-image', 'url("' + $(this).attr('src') + '")');
			$(this).remove();
		});
		miniAvatar.append(miniAvatarImg);
		miniDialog.append(miniAvatar);
		setAsDraggable(miniDialog.get(0), miniAvatar.get(0), function() {
			// on drag start
			console.log('>>> on start');
		}, function() {
			// on drag end
			console.log('>>> on end');
		}, function() {
			// toggle sheet display
			miniDialog.toggleClass('on');
		});
		if (id != null && id) {
			miniAvatar.dblclick(function() {
				openDialogSource(id);
			});
		}
	});

	// -- min-dialog: skills pane
	sheetSrc.find('.character-skill-pane').each(function() {
		var miniSkill = $(this).clone(true);
		sheetSrc.find('.character-title-pane').each(function() {
			var titleSkillBar = $(this).clone(true);
			titleSkillBar.click(function() {
				// toggle Skill pane display
				miniSkill.toggleClass('on');
			});
			miniSkill.prepend(titleSkillBar);
			
			// -- skill pane resizer
			var handle = createCustomObject('div');
			handle.addClass('bottom-resizer');
			var isResizing = false, lastDownX = 0;
			handle.on('mousedown', function (e) {
				isResizing = true;
				lastDownY = e.clientY;
				originHeight = miniSkill.height();
			});
			$(document).on('mousemove', function (e) {
				if (!isResizing)  {
					return;
				}
				var newHeight = originHeight + e.clientY - lastDownY;
				miniSkill.css('height', newHeight);
			}).on('mouseup', function (e) {
				// stop resizing
				isResizing = false;
			});
			miniSkill.append(handle);
		});
		miniDialog.append(miniSkill);
	});
	miniDialog.click(actionPerform);

	return miniDialog;
}

function openDialogSource(id) {
	// dialog source
	$('#journalfolderroot .character[data-itemid="'+id+'"]').click();
}

