//----------------------------------------------------------//
//--------- Chat message handle, parse and decorate --------//
//----------------------------------------------------------//
console.log('CME-----------------------> chat-msg-handler');

// whether or not Roll20 Chat content is loaded
var isChatInit = document.querySelector('.userscript-commandintro') !== null;

//------------------------------------------------------------
// parse chat node case : 
// display an image as background
//------------------------------------------------------------
const DEFAULT_BG_URL = '/images/bg-default.jpg';
function parseAndDisplayBackgroundImage(node) {

	var message = node.innerHTML;
	var idx = message.indexOf(MSG_PREFIX_IMG_BG);
	if(idx >= 0) {
		if (!isChatInit) {
			// loading page => remove node in chat
			node.parentNode.removeChild(node);
		} else {
			console.log('---------------- img-background');
			// parse background-image
			var url = atob(message.substring(idx + 7).trim());
			console.log('---------------- img-background URL : ' + url);
			console.log('---------------- img-background HTML:' + node.innerHTML);
			console.log('---------------- img-background : ' + node);
			node.parentNode.removeChild(node);

			// change image in background
			var backgroundElt = $('#editor-wrapper');
			switch(url) {
				case 'off':
					// set visibility as OFF
					backgroundElt.css('background', 'none');
					break;
				case 'default':
					// set visibility as OFF
					backgroundElt.css('background', DEFAULT_BG_URL);
					break;
				default:
					// change image
					backgroundElt.css('background', 'url("' + url + '")');
					break;
			}
		}
		return true;
	}
	return false;
}

//------------------------------------------------------------
// Create YT media to play in background
//------------------------------------------------------------
function createAudioYT(node, src, hasToPlay) {
	var idx = src.indexOf('watch?v=');
	if (idx >= 0) {
		var substr = src.substring(idx + 8);
		if (substr.indexOf('&') > 0) {
			substr = substr.substring(0, substr.indexOf('&'));
		}
		src = src.substring(0, idx) + 'embed/' + substr + '?enablejsapi=1&autoplay=1&color=white&fs=0&modestbranding=1&version=3&showinfo=0';
	} else {
		alert('url synthax error! (missing watch?v=)');
		return;
	}
	node.remove();

	var jukebox = document.getElementById('jukebox');
	var jukeboxContentFirstChild = jukebox.children[0].children[0];
	if (jukeboxContentFirstChild.id != 'ytContainer') {
		
		var container = createCustomElement("div");
		container.id = 'ytContainer';
		container.style = 'position: absolute; width: 400px; height: 226px; left: -462px; top: 0px;';
		
		// create audio HTML element
		var audioYT = createCustomElement("iframe");
		audioYT.id = "ytPlayer";
		audioYT.src = src;
		audioYT.frameborder = "0";
		audioYT.type = "text/html";
		
		// create close button
		var audioYTCloseBtn = createCustomElement("button");
		audioYTCloseBtn.id = "ytCloser";
		$(audioYTCloseBtn).click(function(){
		  $(container).remove();
		});

		container.appendChild(audioYT);
		container.appendChild(audioYTCloseBtn);

		// add youtube player to jukebox container
		jukebox.children[0].prepend(container);
		jukebox.style.overflow = 'visible';
		document.getElementById('rightsidebar').style.overflow = 'visible';
	} else {
		jukeboxContentFirstChild.children[0].src = src;
	}
}

//------------------------------------------------------------
// parse node case : 
// YT media to play in background
//------------------------------------------------------------
function parseAndPlayYT(node, hasToPlay) {
	var message = node.innerHTML;
	var idx = message.indexOf(MSG_PREFIX_MEDIA_YT);
	if(idx >= 0) {
		var src = atob(message.substring(idx + 3).trim());
		node.innerHTML = node.innerHTML.substring(0, idx);
		var soundIcon = createCustomElement('span');
		soundIcon.classList.add('pictos');
		soundIcon.style = 'font-size:18px; cursor: pointer!important; color:#742d2d';
		soundIcon.title = src;
		soundIcon.innerHTML = '&gt;';
		node.appendChild(soundIcon);
		// parse URL
		createAudioYT(node, src, hasToPlay);
	}
}

//-----------------------------------------------------------------------
// observer on chat content -> parse to play media or display image
//-----------------------------------------------------------------------
var messageObserver = new MutationObserver(function (mutationsList) {
	for(var mutation of mutationsList) {
		if (mutation.type == 'childList') {
			// parse new node added into the chat
			for (var node of mutation.addedNodes) {
				// check init to avoid auto-play media from old msg
				if (node.nodeType === Node.ELEMENT_NODE) {
					if (!isChatInit) {
						isChatInit = document.querySelector('.userscript-commandintro') !== null;
					} else {
						// case : YT video
						if(parseAndPlayYT(node, true)) {
							continue;
						}
					}
					// case : image in background
					if(parseAndDisplayBackgroundImage(node, true)) {
						continue;
					}
				}
			}
		}
	}
});
waitElementExist('textchat', () => {
	let elemChat = document.getElementById('textchat');
	for (var i = 0; i < elemChat.children.length; i++) {
		var e = elemChat.children[i];
		if (e.classList.contains('content')) {
			messageObserver.observe(e, {
				childList: true
			});
			break;
		}
	}
});
