
console.log('CME-----------------------> theme-manager');

//------------------------------------------//
//-------------- Menu D&D ------------------//
//------------------------------------------//
var isGM = false;
var gameData = null;
var menu = createCustomObject('div', 'menu-custom');
var menu_button = createCustomObject('div', 'menu-custom-button');
menu_button.addClass('ripple');
menu_button.click(function() {
	// on click : toogle display of Roll20 map & zoom tool
	const zoom = $('#zoomclick');
	console.log('zoom : ' + zoom);
	const displayValue = zoom.css('display') === 'none' ? 'block': 'none';
	zoom.css('display', displayValue);
	$('.canvas-container').each(function(element) {
		$(this).css('display', displayValue);
	});
});
// by default : hide Roll20 map & zoom tool
$('#zoomclick').css('display', 'none');
$('.canvas-container').each(function(element) {
	$(this).css('display', 'none');
});
menu.css('display', 'none');
menu.append(menu_button);
$('#editor-wrapper').prepend(menu);


//------------------------------------------//
//--------- Splash Screen Strahd -----------//
//------------------------------------------//
const soundURL = browser.runtime.getURL('resources/intro_cthulhu.mp3');
const splashScreen = createCustomElement('div', 'splashScreen');
document.body.appendChild(splashScreen);

const altSpashClass = ['alt-1', 'alt-2', 'alt-3', 'alt-4'];
var altClass = altSpashClass[Math.floor(Math.random() * altSpashClass.length)];
splashScreen.classList.add(altClass);

function displaySplashScreen(time) {
	splashScreen.classList.add('showing');
	setTimeout(function(){
		hideSplashScreen();
	}, time);
	new Audio(soundURL).play();
}

function hideSplashScreen() {
	splashScreen.classList.add('ending');
	setTimeout(function(){
		// hide + change bg forthe next splash
		splashScreen.classList.remove('ending');
		splashScreen.classList.remove('showing');
		for (var alt of altSpashClass) {
			splashScreen.classList.remove(alt);
		}
		splashScreen.classList.add(altSpashClass[Math.floor(Math.random() * altSpashClass.length)]);
	}, 1000);
}


console.log('-----------------------> B');

//------------------------------------------//
//---------- Add tool : Theme --------------//
//------------------------------------------//
var lastTool = document.getElementById('helpsite');
lastTool.insertAdjacentHTML('afterend', '<li id="themeTool" class="'+CUSTOM_ITEM_CLASS+'" tip="Theme On/Off"><img style="opacity:0.4;" src="http://sda-campagne.fr/misc/palette.png"><div class="submenu"><ul><li id="themeDefault">Theme: Roll20</li><li id="themeCthulhu">Theme: Cthulhu Myth</li></ul></div></li>');

var favIconLink = document.querySelector("link[rel*='icon']") || createCustomElement('link');
favIconLink.type = 'image/x-icon';
favIconLink.rel = 'shortcut icon';
favIconLink.href = 'http://sda-campagne.fr/misc/favicon_roll20.png';
document.getElementsByTagName('head')[0].appendChild(favIconLink);

const themeList = ['theme-cthulhu'];

function unsetTheme() {
	document.body.classList.remove(...themeList);
}
function setThemeCthulhu(rollback) {
	localStorage.setItem('theme', 'greek');
	displaySplashScreen(7000);
	setTimeout(function(){
		setTheme('theme-cthulhu', rollback);
	}, 3500);
}
function setTheme(theme, rollback) {
	document.body.classList.remove(...themeList);
	document.body.classList.add(theme);
	rollback();
}
var themeDefault = document.getElementById('themeDefault');
themeDefault.addEventListener('click', unsetTheme, false);
var themeCthulhu = document.getElementById('themeCthulhu');
themeCthulhu.addEventListener('click', setThemeCthulhu, false);

// listen loading overlay to set theme upon loading end
waitElementExist('loading-overlay', initTheme);
function initTheme() {
		console.log('THEME: initTheme');
	var loadingRollback = () => {
		blackScreen.style.display = 'none';
	};
	var isLoaded = document.getElementById('loading-overlay').style.display === 'none';
	if(isLoaded) {
		console.log('THEME: already loaded -> set Theme');
		setThemeCthulhu(loadingRollback);
	} else {
		var observerLoading = new MutationObserver(function (mutationsList) {
			for(var mutation of mutationsList) {
				var e = mutation.target;
				if (e.style.display == 'none') {
					console.log('THEME: loading-overlay hidden');
					if(isLoaded) {
						return;
					}
					isLoaded = true;
					console.log('THEME: set Theme');
					setThemeCthulhu(loadingRollback);
				}
			}
		});
		observerLoading.observe(document.getElementById('loading-overlay'), {
			attributes: true,
			attributeOldValue: false,
			attributeFilter: ['style'],
			characterData: false,
			characterDataOldValue: false,
			childList: false,
			subtree: false
		});
	}
	var blackScreen = createCustomElement('div');
	blackScreen.id = 'blackScreen';
	blackScreen.style.position = 'fixed';
	blackScreen.style.top = '0';
	blackScreen.style.left = '0';
	blackScreen.style.width = '100%';
	blackScreen.style.height = '100%';
	blackScreen.style.zIndex = '99998';
	blackScreen.style.backgroundColor = '#18191b';
	document.body.appendChild(blackScreen);
}

//---------------------------------------------//
//------- Identify initiative panel -----------//
//---------------------------------------------//

// observe initiative panel adding
var initiativePanelObserver = new MutationObserver(function (mutationsList) {
	for(var mutation of mutationsList) {
		if (mutation.type == 'childList') {
			// parse added node
			for (var node of mutation.addedNodes) {
				if (node.nodeType === Node.ELEMENT_NODE) {
					if (node.className.indexOf('ui-dialog') >= 0) {
						// this is the initiative panel opening
						for (var child of node.childNodes) {
							if(child.id === 'initiativewindow') {
								node.id = 'initiativedialog';
							}
						}
					}
				}
			}
		}
	}
});
initiativePanelObserver.observe(document.body, {
	childList: true
});


//------------------------------------------//
//---------- build deco custom -------------//
//------------------------------------------//
var decoLeft = createCustomElement('div');
decoLeft.id = 'editor-deco-left';
document.body.appendChild(decoLeft);
var decoRight = createCustomElement('div');
decoRight.id = 'editor-deco-right';
document.body.appendChild(decoRight);

function displayDetailsData(cardData) {
	if(cardData.type === 'Personnages') {
		for(var pj of gameData.players) {
			if(pj.nom === cardData.title) {
				setCurrentPJ(pj);
				displayCharSheets();
			}
		};
	} else {
		if(cardData.img) {
			detailsImg.style.backgroundImage = 'url("'+cardData.img+'")';
		} else {
			detailsImg.style.backgroundImage = 'url("http://www.sda-campagne.fr/misc/greek_theme/data/default_card.jpg")';
		}
		detailsTitle.innerHTML = cardData.title;
		detailsTxt.innerHTML = cardData.desc;
	}
}
function displayDetails(detailsId) {
	var details = localStorage.getItem("details");
	console.log('displayDetails: ' + details);
	if (details) {
		console.log('parse data...');
		details = JSON.parse(details);
		for (var data of details) {
			if(data.id === detailsId) {
				console.log('parse res: ' + data);
				displayDetailsData(data);
				break;
			}
		}
	} else {
		console.log('no data');
	}
}


