

//-------------------------------------------//
//------------ Character Folding ------------//
//-------------------------------------------//


var leftsidebar = createCustomObject('div', 'leftsidebar');
var leftsidebarToggler = createCustomObject('div', 'leftsidebar-toggler');
var leftsidebarTogglerDeco = createCustomObject('div');
leftsidebarTogglerDeco.addClass('deco');
leftsidebarToggler.click(function() {
	switch(leftsidebar.attr('display-mode')) {
		case 'folding':
			leftsidebar.attr('display-mode', '');
			break;
		default:
			leftsidebar.attr('display-mode', 'folding');
			break;
	}
});
leftsidebarToggler.append(leftsidebarTogglerDeco);
leftsidebar.append(leftsidebarToggler);
$(document.body).append(leftsidebar);

doWhenLoad(() => {
	console.log('BUILD CHARACTER PANE !!!');
/*
	// toggler character wizard
	var button = createCustomObject('div', 'character-wizard-toggler');
	var buttonIcon = createCustomObject('div');
	buttonIcon.addClass('icon');
	button.append(buttonIcon);
	$(document.body).append(button);
*/
	// character wizard -> from journal character
	var pane = createCustomObject('div', 'character-wizard');
	$('#journalfolderroot > .dd-list').each(function() {
		
		console.log(' PARSE JOUNRAL !!!');

		var folders = [];
		$(this).find('.dd-item.dd-folder[data-globalfolderid]').each(function() {
			var folderId = $(this).attr('data-globalfolderid');
			console.log(' PARSE folder !!! ' + $(this).attr('data-globalfolderid'));

			// build folder nodes
			var chars = [];
			$(this).find('> .dd-list > .journalitem.character[data-itemid]').each(function() {
				var source = $(this);
				const charId = source.attr('data-itemid');
				console.log(' PARSE JOUNRAL !!! character : ' + charId);
				var char = createCustomObject('div');
				char.addClass('char');
				char.attr('data-itemid', charId);
				char.click(function() {
					//source.click()
				});

				// -- image => action : open source dialog
				var imageSrc = source.find('img').first().attr('src');
				var image = createCustomObject('div');
				image.addClass('image');
				image.css('background-image', 'url("'+imageSrc+'")');
				image.addClass('source');
				image.addClass('open-dialog');
				image.attr('data-characterid', charId);
				char.append(image);

				// -- name => action : pinn character sheet
				var name = createCustomObject('div');
				name.addClass('name');
				name.html(source.find('.namecontainer').first().html());
				name.addClass('pinn-sheet');
				name.attr('data-characterid', charId);
				char.append(name);

				// -- menu
				var menu = createCustomObject('div');
				menu.addClass('char-list-menu');
				var menuItem = createCustomObject('div');
				menuItem.addClass('put-to-hand');
				menuItem.attr('data-characterid', charId);
				menuItem.attr('src-img', imageSrc);
				menu.append(menuItem);
				menuItem = createCustomObject('div');
				menuItem.addClass('drop-out');
				menuItem.attr('data-characterid', charId);
				menu.append(menuItem);

				char.append(menu);

				chars.push(char)
			});

			// store folder nodes
			if (chars.length > 0) {
				console.log(' STORE FOLDER CHAR >>> ' + folderId);
				var folderName= $(this).children('.dd-content').children('.folder-title').first().html();
				folders.push({
					id: folderId,
					name: folderName,
					items: chars
				});
			}
		});

		for (const folder of folders) {
			console.log(' BUILD FOLDER >>> ' + folder.name);
			const folderPane = createCustomObject('div');
			folderPane.addClass('char-folder');
			folderPane.addClass('root');

			// -- Folder Title
			const titleBar = createCustomObject('div');
			titleBar.addClass('title');

			const titleName = createCustomObject('div');
			titleName.html(folder.name);
			titleName.addClass('title-name');
			titleName.click(function() {
				folderPane.toggleClass('on');
			});
			titleBar.append(titleName);
			
			// -- action : layout
			var layoutBtn = createCustomObject('div');
			layoutBtn.addClass('layout-change');
			titleBar.append(layoutBtn);
			
			// -- action : put all character into the hand
			var putAllToHandBtn = createCustomObject('div');
			putAllToHandBtn.addClass('put-all-to-hand');
			titleBar.append(putAllToHandBtn);

			folderPane.append(titleBar);
			for (const charItem of folder.items) {
				console.log(' ADD CHAR ... ');
				folderPane.append(charItem);
			}
			pane.append(folderPane);
		}
		/*if (pane.children().length == 1) {*/
			pane.children().addClass('on');
		/*}*/
		pane.click(actionPerform);
	});
	$('#leftsidebar').append(pane);
});

//-------------------------------------------//
//------------ Character manager ------------//
//-------------------------------------------//
const _characterRefMap = new Map();
var _floatingSheets = new Map();
var _sources = new Map();
var _hiddenLoading = new Map();
function createCharacter(id) {
	var character = _floatingSheets.get(id);
	if (character == null) {
		character = new Character(id);
		storeCharacter(character);
	}
	return character;
}
function storeCharacter(character) {
	_characterRefMap.set(character.id, character);
}
function storeFloatingSheet(miniDialog) {
	_floatingSheets.set(miniDialog.attr('data-id'), miniDialog);
}
function notifyCharacterViews(id) {
	console.log('notifyCharacterViews...');
	var character = _characterRefMap.get(id);
	var miniDialog = _floatingSheets.get(id);
	var source = _sources.get(id);
	if (miniDialog != null && character != null) {
		console.log('refreshMiniFloatingSheet...');
		refreshMiniFloatingSheet(miniDialog, character);
	}
	var pinnedSheet = $('#pinned-sheet');
	if(pinnedSheet != null && pinnedSheet.attr('data-id') == character.id) {
		console.log('refresh PinnSheet...');
		buildPinnSheetContent(pinnedSheet, character);
	}
	// close hidden dialog
	var source = findSourceDialog(character.id);
	console.log('close hidden dialog ? ' + source.attr('class'));
	if (source.hasClass('hidden-source')) {
		console.log('close hidden dialog >>> need close');
		source.find('> .ui-dialog-titlebar .ui-icon-closethick').click();
		console.log('close hidden dialog >>> remove class');
		source.removeClass('hidden-source');
	}
	_hiddenLoading.clear();
}
function removeFloatingSheet(id) {
	var miniDialog = _characterRefMap.get(id);
	if (miniDialog != null) {
		miniDialog.remove();
	}
}
function findSourceDialog(id) {
	var source = _sources.get(id);
	if (source == null) {
		source = $(document.body).children('.ui-dialog').has('.dialog.characterdialog[data-characterid="'+id+'"]').first();
		console.log('findSourceDialog >>> ' + source);
		console.log('findSourceDialog >>> id ' + id);
		console.log('findSourceDialog >>> class ' + source.attr('class'));
		console.log('findSourceDialog >>> source ? ' + source.length);
		_sources.set(id, source);
	}
	console.log('findSourceDialog ::: ' + source);
	console.log('findSourceDialog ::: class ' + source.attr('class'));
	return source;
}
function isSourceLoaded(source) {
	console.log('isSourceLoaded ?');
	return source != null
		&& source.find('.characterviewer .sheetform input[name="attr_sheet_initialized"][value="yes"]').length > 0
		&& source.find('.characterviewer .sheet-pc').length > 0;
}

// listener to update Character automatically upon dialog open
doWhenChildCreated(
	$(document.body),
	node => node.hasClass('ui-dialog'),
	node => {
		// check each character
		node.find('.dialog.characterdialog[data-characterid]').each(function() {
			var content = $(this);
			var characterId = content.attr('data-characterid');
			if(_hiddenLoading.get(characterId)) {
				node.addClass('hidden-source');
			}
			_sources.set(characterId, node);
			console.log('>> character dialog CREATED... ' + characterId);
			console.log('>> read from cache character : ' + characterId);
			var character = readCharacterFromCache(characterId);
			console.log('>> readCharacterFromCache res : ' + (character != null));
			if (character != null) {
				character.pendingData = true;
				console.log('>> -- performDataLoading : ' + characterId);
				performDataLoading(character, 6);
				console.log('>> -- performDataLoading : END');
			}
			// refresh on display change
			console.log('>> -- doWhenDislayChange');
			doWhenDislayChange(node, node => {
				console.log('doWhenDislayChange ... dislay = ' + node.css('display'));
				var character = readCharacterFromCache(characterId);
				if(character != null && node.css('display') == 'block') {
					character.pendingData = true;
					console.log('doWhenDislayChange next ...');
					performDataLoading(character, 6);
				}
			});
		});
	}
);

function performDataLoading(character, nbAttempt) {
	console.log('performDataLoading >>>> ...('+nbAttempt+') : pending ? ' + character.pendingData);
	if (nbAttempt <= 0 || !character.pendingData) {
		character.pendingData = false;
		console.log('performDataLoading >>>> aborted');
		return;
	}
	console.log('performDataLoading >>>> Check ('+nbAttempt+') data loading : ' + character.id);

	var source = findSourceDialog(character.id);
	
	if (isSourceLoaded(source)) {
		console.log('performDataLoading >>>> OK ('+nbAttempt+') data loaded : ' + character.id);
		console.log('performDataLoading >>>> source ' + source);
		console.log('performDataLoading >>>> source class ' + source.attr('class'));
		character.refresh(source);
	} else {
		console.log('performDataLoading >>>> Check ('+nbAttempt+') sheet not found!');
		setTimeout(performDataLoading, 400, character, nbAttempt-1);
	}
}
function loadData(character) {
	console.log('>> forceToLoadData for character : ' + character.id + '...');
	var source = findSourceDialog(character.id);
	console.log('>> forceToLoadData for character : ' + character.id + '... source ' + source);
	var isDataLoad = isSourceLoaded(source);
	console.log('>> forceToLoadData for character : ' + character.id + '... is load ' + isDataLoad);
	if (!isDataLoad) {
		console.log('>> forceToLoadData for character : ' + character.id + ' => source need to be open in hidden');
		// enforce data load (open dialog in hidden)
		openHiddenSource(character, source); // N.B: listening will enforce refresh
	} else {
		character.refresh(source);
	}
}
function openHiddenSource(character, source) {
	console.log('>> openHiddenSource for character : ' + character.id);
	// dialog source need to be open in hidden
	var openDialogTrigger = null;
	$('#journalfolderroot .character[data-itemid="'+character.id+'"]').each(function() {
		console.log('>> openHiddenSource for character : ' + character.id + ' => trigger found');
		openDialogTrigger = $(this);
		// open dialog to load data
		character.pendingData = true;
		markAsHiddenDialog(character.id);
		openDialogTrigger.click();
		console.log("openDialogTrigger ... click");
	});
	if (openDialogTrigger == null) {
		console.log('>> openHiddenSource for character : ' + character.id + ' => data no found in journal');
		// character not anymore available => dispose character
		character.dispose();
	} 
}
function markAsHiddenDialog(id) {
	console.log("markAsHidden ...");
	_hiddenLoading.set(id, true);
	var dialog = findSourceDialog(id);
	if (dialog != null) {
		console.log("markAsHidden >>> source found");
		dialog.addClass('hidden-source');
		console.log("markAsHidden >>> source hidden");
	}
	console.log("markAsHidden ... OK");
}

// get sheet data from cache
function readCharacterFromCache(id) {
	return _characterRefMap.get(id);
}

//------------------------------------------------//
//------------ Character data classes ------------//
//------------------------------------------------//
class CharacterInfos {
	name;
	constructor() {
	}
}
class Attribute {
	key;
	value;
	macro;
	name;
	shortName;
	constructor() {
	}
}
class SecondaryAttribute {
	key;
	value;
	max;
	macro;
	name;
	constructor() {
	}
}
class Skill {
	key;
	value;
	macro;
	name;
	constructor() {
	}
}
class Character {
	constructor(id) {
		this.listeners = new Map();
		this.onetimeListeners = new Map();
		this.disposeListeners = new Map();
		this.pendingData = true;
		
		// roll20 character id
		this.id = id;
		this.attributeList = [];
		console.log('>>>>>>>> new Character ' + id);
		this.secAttributeList = [];
		this.skillList = [];
	}

	refresh(sourceDialog) {
		console.log('!!!!!! refresh');
		if (this.pendingData, sourceDialog != null) {
			this.pendingData = false;
			console.log('!!!!!! refresh with source');
			this._populate(sourceDialog);
			this._notifyUpdate();
			console.log('>>>>>> refresh...END');
		} else {
			this.pendingData = true;
			console.log('!!!!!! refresh no source');
			loadData(this);
		}
	}

	dispose() {
		console.log('>>>>>> dispose...');

		removeFloatingSheet(this.id);

		console.log('>>>>>> dispose...END');
	}

	_notifyUpdate() {
		console.log('>>>>>> _notifyUpdate...');

		notifyCharacterViews(this.id);

		console.log('>>>>>> _notifyUpdate...END');
	}

	_populate(sourceDialog) {
		console.log('>>>>>>>> _populate...');
		var that = this;
		this.attributeList = [];
		this.secAttributeList = [];
		this.skillList = [];
		this.avatarURL = null;	 			// avatar image URL
		this.infos = new CharacterInfos(); 	// name, ...
		this.macroOptions = new Map();

		console.log('!!!!!! SOURCE ' + sourceDialog.attr('class'));
		this.avatarURL = sourceDialog.find('.avatar img[src]').first().attr('src');

		const sheet = sourceDialog.find('.sheet-pc').first();
		console.log('>>>>>>>> _populate... FROM : ' + sourceDialog.find('.sheet-pc').length);

		const characterId = sourceDialog.find('.dialog.characterdialog[data-characterid]').first().attr('data-characterid');

		// macro roll options
		const macroOptions = this.macroOptions;

		// macro key values
		const macroAttrKeyMap = new Map();
		const charNameKey = 'character_name';
		const rollDifficultyKey = 'dice_toggle';
		const rollWhisperKey = 'roll_whisper';
		// -- Global parameters
		macroAttrKeyMap.set('character_id', characterId);
		sourceDialog.find(".sheet-coc7e > input[name^='attr_']").each(function () {
			macroAttrKeyMap.set($(this).attr('name').substring(5), $(this).attr('value'))
		});
		// -- Attributes & skills values
		sheet.find("div.sheet-edit-hide span[name^='attr_']").each(function () {
			macroAttrKeyMap.set($(this).attr('name').substring(5), $(this).html())
		});

		// force options
		macroAttrKeyMap.set(rollWhisperKey, '');
		sheet.find(".sheet-checkmark-item[data-i18n-title~='verbose'] input[name^='attr_" + rollDifficultyKey + "']").each(function () {
			console.log('OPTIONS !!! ' + rollDifficultyKey);
			macroAttrKeyMap.set(rollDifficultyKey, $(this).attr('value'))
		});

		// -- Roll options (variable)
		sheet.find(".sheet-checkmark-item input:checked[name^='attr_" + rollDifficultyKey + "']").each(function () {
			macroOptions.set($(this).attr('name').substring(5), $(this).attr('value'))
		});
		macroOptions.set(rollWhisperKey, '');
		// -- set macro parameters functions
		var replaceParam = function (str, parameters) {
			return str.replace(/@{(\w+)}/g, function (_, k) {
				console.log('macro : ' + k + ' >> ' + parameters.get(k));
				return parameters.get(k) == null ? ('@{' + k + '}') : parameters.get(k);
			});
		}
		var replaceMacroTitle = function (str, value) {
			return str.replace(/\{\{title=([@\{\}\w+ ]+)\}\}/g, function (_, k) {
				return '{{title=' + value + '}}';
			});
		}

		// ---------------- character infos ---------------- //
		console.log('!!!!!! INFOs');
		this.infos.name = macroAttrKeyMap.get(charNameKey);
		// TODO : this.infos.xxx =...

		// ---------------- attributes ---------------- //
		console.log('!!!!!! ATTRs ');
		sheet.find('.sheet-character-attributes .sheet-attribute-display').each(function () {
			var attrSource = $(this);
			var attr = new Attribute();
			// get translated name + set short name
			attrSource.find('strong[data-i18n]').each(function () {
				attr.key = $(this).attr('data-i18n');
				attr.name = $(this).html();
				attr.shortName = $(this).html().substring(0, 3);
			});
			attrSource.find('.sheet-edit-hide span').each(function () {
				attr.value = $(this).html();
			});
			// store macro
			attrSource.find('[type="roll"]').each(function () {
				var macro = replaceMacroTitle($(this).attr('value'), attr.name);
				attr.macro = replaceParam(macro, macroAttrKeyMap);
			});
			that.attributeList.push(attr);
		});
		console.log('!!!!!! ATTRs >>> ' 
		+ that.attributeList.length
		+ " / " 
		+ sheet.find('.sheet-character-attributes .sheet-attribute-display').length);

		// ---------------- secondary attributes ---------------- //
		console.log('!!!!!! SEC ATTRs');
		sheet.find('.sheet-character-secondary-attributes .sheet-attribute-display').each(function () {
			var secAttrSource = $(this);
			var secAttr = new SecondaryAttribute();
			secAttrSource.find('.sheet-minmax-display > strong[data-i18n]').each(function () {
				secAttr.key = $(this).attr('data-i18n').replace(' ', '-');
				secAttr.name = $(this).html();
			});
			secAttrSource.find('.sheet-minmax-display-value').each(function () {
				secAttr.value = $(this).html();
			});
			secAttrSource.find('.sheet-minmax-display-max').each(function () {
				secAttr.max = $(this).html();
			});
			secAttr.macro = null;
			secAttrSource.find('[type="roll"]').each(function () {
				var macro = replaceMacroTitle($(this).attr('value'), secAttr.name);
				secAttr.macro = replaceParam(macro, macroAttrKeyMap);
			});
			that.secAttributeList.push(secAttr);
		});
		console.log('!!!!!! SEC ATTRs >>> ' 
		+ that.secAttributeList.length 
		+ " / " 
		+ sheet.find('.sheet-character-secondary-attributes .sheet-attribute-display').length);

		// ---------------- skills ---------------- //
		console.log('!!!!!! SKILLs');
		sheet.find('.sheet-skills .sheet-skill-display-wrapper:not(.sheet-edit-show)').each(function () {
			var skillSource = $(this);
			var skillName;
			// get translated name (regular skill)
			skillSource.find('.sheet-skill-display-title').each(function () {
				skillName = $(this).html();
			});
			// get translated name (custom skill)
			skillSource.find('span[name="attr_name"]').each(function () {
				skillName = $(this).html();
			});
			// no name => do nothing
			if (skillName == null || !skillName) {
				return;
			}
			var skill = new Skill();
			skill.name = skillName;
			// skill value
			skillSource.find('.sheet-skill-display-value').each(function () {
				skill.value = $(this).html();
				macroAttrKeyMap.set('value', skill.value); // useful for custom skill
			});
			// action
			skillSource.find('[type="roll"]').each(function () {
				var macro = replaceMacroTitle($(this).attr('value'), skill.name);
				skill.macro = replaceParam(macro, macroAttrKeyMap);
			});
			that.skillList.push(skill);
		});
		console.log('!!!!!! SKILLs >>> ' + that.skillList.length);
	}
}



//-----------------------------------------------------//
//------------ Pinned Character sheet Pane ------------//
//-----------------------------------------------------//
const macroOptionKeyMap = new Map();

// Pinned character Pannel
var pinnedSheet = createCustomObject('div', 'pinned-sheet');
pinnedSheet.addClass('character-pannel');
$('#leftsidebar').append(pinnedSheet);

// Pinned character display toggle button
const characterSheetButton = createCustomObject('div');
characterSheetButton.addClass('character-sheet-button');
$(document.body).append(characterSheetButton);
const characterSheetButtonIcon = createCustomObject('div');
characterSheetButtonIcon.addClass('character-sheet-button-icon');
characterSheetButton.append(characterSheetButtonIcon);
characterSheetButton.click(() => {
	console.log('characterSheetButton CLICK !!!');
	if (!pinnedSheet.hasClass('data')) {
		showPinnedCharSheet(false);
		var index = $('#rightsidebar > ul.tabmenu a[href="#journal"]').parent().index();
		$('#rightsidebar').tabs({
		  active: index
		});
	} else {
		showPinnedCharSheet(!pinnedSheet.hasClass('on'));	
	}
});

function showPinnedCharSheet(display) {
	console.log('showPinnedCharSheet :: ' + display);
	if (display) {
		$('#rightsidebar .character-pannel').addClass('on');
		$('#character-sheet-button').addClass('on');
	} else {
		$('#rightsidebar .character-pannel').removeClass('on');
		$('#character-sheet-button').removeClass('on');
	}
}

// Add pinn action button into each character sheet dialog
// --1 : Observer adding pinn button into new created dialogs
new MutationObserver(function (mutationsList) {
	for(var mutation of mutationsList) {
		if (mutation.type == 'childList') {
			// parse new node added into the chat
			for (var node of mutation.addedNodes) {
				// check init to avoid auto-play media from old msg
				if (node.nodeType === Node.ELEMENT_NODE) {
					var myNode = $(node);
					if (myNode.hasClass('ui-dialog')) {
						initPinnButton(myNode, 0);
					}
				}
			}
		}
	}
}).observe(document.body, {
	childList: true
});
// -- 2: Add pinn action button into existing dialogs
$(document.body).find('.ui-dialog').each(function() {
	if ($(this).has('.sheet-coc7e')) {
		addPinnButton($(this));
	}
});

function initPinnButton(root, nbOfAttempt) {
	if (nbOfAttempt >= 5) {
		return;
	}
	if (root.has('.characterviewer')) {
		addPinnButton(root);
	} else {
		setTimeout(initPinnButton, 400, root, nbOfAttempt+1);
	}
}

function addPinnButton(root) {
	root.find('.characterviewer').each(function() {
		var pinnBtn = createCustomObject('div');
		pinnBtn.addClass('character-sheet-button');
		pinnBtn.addClass('ripple');
		var characterSheetButtonIcon = createCustomObject('div');
		characterSheetButtonIcon.addClass('character-sheet-button-icon');
		pinnBtn.append(characterSheetButtonIcon);
		root.append(pinnBtn);
		pinnBtn.click(function() {
			if(root.has('.sheet-pc')) {
				console.log('!!!!!! Click => create Character');
				// Sheet PJ
				var id = root.find('.dialog.characterdialog').first().attr('data-characterid');
				console.log('!!!!!! Click => create Character ' + id);
				pinnCharacterSheet(id);
			} else if(root.has('.sheet-npc')) {
				// Sheet PNJ
				// TODO ...
			}
		});
	});
}

//------------------------------------------------------//
//------------ Create pinned character sheet------------//
//------------------------------------------------------//
function pinnCharacterSheet(id) {
	console.log('pinnCharacterSheet ' + id);

	// init
	pinnedSheet.attr('data-id', id);
	pinnedSheet.addClass('root');
	pinnedSheet.addClass('on');

	var character = readCharacterFromCache(id);
	if (character == null) {
		console.log('createCharacter ' + id);;
		character = createCharacter(id);
	} else {
		buildPinnSheetContent(pinnedSheet, character);
	}

	// refresh character data
	character.refresh();

	// display pinned sheet
	showPinnedCharSheet(true);
	console.log('pinnCharacterSheet :: END');
}
function buildPinnSheetContent(pinnedSheet, character) {
		
	// clear previous data
	console.log('pinnCharacterSheet :: clear previous data');
	pinnedSheet.children().remove();

	// source sheet open button
	console.log('pinnCharacterSheet :: open-dialog sheet button');
	const sourceOpenBtn = buildCharacterSourceOpenBtn(character);
	pinnedSheet.append(sourceOpenBtn);

	// source sheet open button
	console.log('pinnCharacterSheet :: toggle-display sheet button');
	const toggleDisplayBtn = buildCharacterToggleDisplayBtn(character);
	pinnedSheet.append(toggleDisplayBtn);
		
	// avatar
	console.log('pinnCharacterSheet :: avatar');

	var characterAvatarPane = buildCharacterAvatarPane(character);
	pinnedSheet.append(characterAvatarPane);
	
	// Character Name
	console.log('pinnCharacterSheet :: Character Name');
	var characterTitlePane = buildCharacterNamePane(character);
	pinnedSheet.append(characterTitlePane);
	
	// Global Attribute Pane
	console.log('pinnCharacterSheet :: Global Attribute Pane');
	const characterGlobalAttrPane = buildCharacterGlobalAttrPane(character);
	pinnedSheet.append(characterGlobalAttrPane);

	// Skills
	console.log('pinnCharacterSheet :: Skills');
	const characterSkillPane = buildCharacterSkillPane(character);
	pinnedSheet.append(characterSkillPane);
	
	pinnedSheet.addClass('data');
}

//--------------------------------------------------------//
//------------ Create floating character sheet------------//
//--------------------------------------------------------//
function createMiniFloatingSheet(id) {
	console.log('createMiniFloatingSheet' + id);
	var character = readCharacterFromCache(id);
	console.log('createMiniFloatingSheet' + character);
	if (character == null) {
		var character = createCharacter(id);
	}
	
	console.log('>>> CREATE mini dialog : source class=' + character.id);
	if($('.mini-dialog[data-id="'+character.id+'"]').length > 0) {
		console.log('>>> ALREADY EXIST mini dialog : source class=' + character.id);
		return;
	}
	console.log('>>> CREATE mini dialog : source class=' + character.id);

	// create sheet as min-dialog
	var miniDialog = createCustomObject('div');
	miniDialog.attr('data-id', character.id);
	miniDialog.addClass('character-pannel');
	miniDialog.addClass('mini-dialog');
	miniDialog.addClass('on');
	miniDialog.css('top', '200px');
	miniDialog.css('left', '200px');
	miniDialog.click(actionPerform);

	buildMiniFloatingSheetContent(miniDialog, character);

	$(document.body).append(miniDialog);

	// refresh character data
	character.refresh();
}
function refreshMiniFloatingSheet(miniDialog, character) {
	miniDialog.children().remove();
	buildMiniFloatingSheetContent(miniDialog, character);
}

function buildMiniFloatingSheetContent(miniDialog, character) {

	// -- min-dialog: global attributes pane
	const miniMainAttr = buildCharacterGlobalAttrPane(character);
	// -- close button
	var miniCloseBtn = createCustomObject('div');
	miniCloseBtn.addClass('close-btn');
	miniCloseBtn.click(function() {
		// close mini dialog
		miniDialog.remove();
	});
	miniMainAttr.append(miniCloseBtn);
	miniDialog.append(miniMainAttr);

	// -- min-dialog: avatar pane
	const miniAvatar = buildMiniAvatarPane(miniDialog, character);
	miniDialog.append(miniAvatar);

	// -- min-dialog: skills pane
	const miniSkill = buildCharacterSkillPane(character);
	var skillOptPane = miniSkill.children('.skill-list-options').first();
	const titleSkillBar = buildCharacterNamePane(character);
	titleSkillBar.click(function() {
		// toggle Skill pane display
		miniSkill.toggleClass('on');
	});
	skillOptPane.prepend(titleSkillBar);
	
	// -- skill pane resizer
	var handle = buildMiniSkillResizer(miniSkill);
	miniSkill.append(handle);
	miniDialog.append(miniSkill);

	// -- min-dialog: circle menu
	miniDialog.append(buildMiniSheetMenu(character));
}

//-------------------------------------------------------------//
//------------ functions about custom sheets build ------------//
//-------------------------------------------------------------//
function buildCharacterSourceOpenBtn(character) {
	const characterSourceOpenBtn = createCustomObject('div');
	characterSourceOpenBtn.addClass('open-dialog');
	characterSourceOpenBtn.attr('data-characterid', character.id);
	return characterSourceOpenBtn;
}
function buildCharacterToggleDisplayBtn(character) {
	const toggleDisplayBtn = createCustomObject('div');
	toggleDisplayBtn.addClass('toggle-display');
	return toggleDisplayBtn;
}

function buildCharacterAvatarPane(character) {
	const characterAvatarPane = createCustomObject('div');
	characterAvatarPane.addClass('character-avatar-pane');
	characterAvatarPane.addClass('drop-out');
	characterAvatarPane.attr('data-characterid', character.id);
	
	var avatarImg = createCustomObject('img');
	avatarImg.attr('src', character.avatarURL);
	avatarImg.addClass('drop-out');
	avatarImg.attr('data-characterid', character.id);
	
	characterAvatarPane.append(avatarImg);
	return characterAvatarPane;
}

function buildMiniAvatarPane(miniDialog, character) {
	var avatarSrc = character.avatarURL;

	miniAvatarImg = createCustomObject('div');
	miniAvatarImg.addClass('image');
	miniAvatarImg.css('background-image', 'url("' + avatarSrc + '")');

	var miniAvatar = createCustomObject('div');
	miniAvatar.addClass('character-avatar-pane');
	miniAvatar.append(miniAvatarImg);
	miniDialog.append(miniAvatar);
	setAsDraggable(miniDialog.get(0), miniAvatar.get(0), function() {
		// on drag start
		console.log('>>> on start');
	}, function() {
		// on drag end
		console.log('>>> on end');
	}, function() {
		// toggle sheet display
		miniDialog.toggleClass('on');
	});
	return miniAvatar;
}

function buildMiniSkillResizer(miniSkill) {
	console.log('SIZER !!! BEGIN');
	var handle = createCustomObject('div');
	handle.addClass('bottom-resizer');
	var isResizing = false;
	handle.on('mousedown', function (e) {
		isResizing = true;
		lastDownY = e.clientY;
		originHeight = miniSkill.height();
		miniSkill.addClass('resizing');
	});
	$(document).on('mousemove', function (e) {
		if (!isResizing)  {
			return;
		}
		var newHeight = originHeight + e.clientY - lastDownY;
		miniSkill.css('height', newHeight);
		miniSkill.css('max-height', newHeight);
	}).on('mouseup', function (e) {
		// stop resizing
		isResizing = false;
		miniSkill.removeClass('resizing');
	});
	console.log('SIZER !!! END');
	return handle;
}

function buildMiniSheetMenu(character) {
	// build menu
	var circleDialogMenu = createCustomObject('div');
	circleDialogMenu.addClass('mini-dialog-menu');
	
	// -- menu action : open source dialog
	var menuItemOpenSource = createCustomObject('div');
	menuItemOpenSource.addClass('open-dialog');
	menuItemOpenSource.attr('data-characterid', character.id);
	circleDialogMenu.append(menuItemOpenSource);
	
	// -- menu action : pinn sheet to the right pane
	var menuItemPinn = createCustomObject('div');
	menuItemPinn.addClass('pinn-sheet');
	menuItemPinn.attr('data-characterid', character.id);
	circleDialogMenu.append(menuItemPinn);
	
	// -- menu action : put as card into the hand
	var menuItemPutToHand = createCustomObject('div');
	menuItemPutToHand.addClass('put-to-hand');
	menuItemPutToHand.attr('data-characterid', character.id);
	menuItemPutToHand.attr('src-img', character.avatarURL);
	circleDialogMenu.append(menuItemPutToHand);
	
	// -- menu action : refresh data
	var menuItemRefreshData = createCustomObject('div');
	menuItemRefreshData.addClass('refresh-data');
	menuItemRefreshData.attr('data-characterid', character.id);
	circleDialogMenu.append(menuItemRefreshData);

	return circleDialogMenu;
}

function buildCharacterNamePane(character) {
	const characterTitlePane = createCustomObject('div');
	characterTitlePane.addClass('character-title-pane');
	characterTitlePane.html(character.infos.name);
	return characterTitlePane;
}

function buildCharacterGlobalAttrPane(character) {
	console.log('buildCharacterGlobalAttrPane :: Global Attributes');
	const characterGlobalAttrPane = createCustomObject('div');
	characterGlobalAttrPane.addClass('character-global-attr-pane');
	characterGlobalAttrPane.addClass('character-sub-pane');
	
	// Main attributes
	console.log('buildCharacterGlobalAttrPane :: Attributes');
	var characterAttributesPane = createCustomObject('div');
	characterAttributesPane.addClass('character-attr-pane');
	console.log('buildCharacterGlobalAttrPane :: attr nb ' + character.attributeList.length);
	character.attributeList.forEach(attr => {
		console.log('buildCharacterGlobalAttrPane :: attr ' + attr.name);
		var attrDiv = createCustomObject('div');
		attrDiv.addClass('sheet-attribute-display');
		attrDiv.addClass('short-attr');
		attrDiv.attr('title', attr.name.charAt(0).toUpperCase() + attr.name.slice(1));
		var attrName = createCustomObject('strong');
		attrName.html(attr.shortName);
		var attrValue = createCustomObject('div');
		attrValue.html(attr.value);
		attrDiv.append(attrName);
		attrDiv.append(attrValue);
		attrDiv.addClass('macro');
		attrDiv.attr('data', attr.macro);
		attrDiv.find('*').each(function() {
			$(this).addClass('macro');
			$(this).attr('data', attr.macro);
		});
		characterAttributesPane.append(attrDiv);
	});
	characterGlobalAttrPane.append(characterAttributesPane);
	
	// Secondary attributes
	console.log('buildCharacterGlobalAttrPane :: Secondary attributes');
	var characterSecondaryAttrPane = createCustomObject('div');
	characterSecondaryAttrPane.addClass('character-sec-attr-pane');
	console.log('buildCharacterGlobalAttrPane :: Secondary attributes ...');
	character.secAttributeList.forEach(secAttr => {
		// console.log('buildCharacterGlobalAttrPane :: attr ' + secAttr.name);
		var secAttrDiv = createCustomObject('div');
		secAttrDiv.addClass('sec-attr');
		secAttrDiv.addClass(secAttr.key);
		secAttrDiv.attr('title', secAttr.name.charAt(0).toUpperCase() + secAttr.name.slice(1));

		// -- name
		var secAttrName = createCustomObject('div');
		secAttrName.addClass('name');
		secAttrName.addClass(secAttr.key);
		// -- value / max value
		var valueCurrent = createCustomObject('div');
		valueCurrent.addClass('value');
		var valueSeparator = createCustomObject('div');
		valueSeparator.addClass('separator');
		var valueMax = createCustomObject('div');
		valueMax.addClass('max');

		valueCurrent.html(secAttr.value);
		valueSeparator.html('/');
		valueMax.html(secAttr.max);

		var secAttrValueDiv = createCustomObject('div');
		secAttrValueDiv.addClass('values');
		secAttrValueDiv.append(valueCurrent);
		secAttrValueDiv.append(valueSeparator);
		secAttrValueDiv.append(valueMax);

		secAttrDiv.append(secAttrName);
		secAttrDiv.append(secAttrValueDiv);
		if (secAttr.macro != null) {
			secAttrDiv.addClass('macro');
			secAttrDiv.attr('data', secAttr.macro);
			secAttrDiv.find('*').each(function() {
				$(this).addClass('macro');
				$(this).attr('data', secAttr.macro);
			});
		}
		characterSecondaryAttrPane.append(secAttrDiv);
	});
	characterGlobalAttrPane.append(characterSecondaryAttrPane);
	console.log('buildCharacterGlobalAttrPane :: Secondary attributes > END');

	return characterGlobalAttrPane;
}

function buildCharacterSkillPane(character) {
	// Skills
	const skillRefNodes = [];
	const skillDisplayedNodes = [];
	character.skillList.forEach(skill => {
		// console.log('buildCharacterSkillPane :: attr ' + skill.name);
		var skillNode = buildSkillWrapper(skill);
		skillDisplayedNodes.push(skillNode);
		skillRefNode = skillNode.clone(true);
		skillRefNode.addClass('hidden');
		skillRefNode.addClass('ref');
		skillRefNodes.push(skillRefNode);
	});
	
	const characterSkillPane = createCustomObject('div');
	characterSkillPane.addClass('character-skill-pane');
	characterSkillPane.addClass('character-sub-pane');

	// pane to hide filtered skill wrappers
	const hiddenSkillPane = createCustomObject('div');
	hiddenSkillPane.addClass('hidden-skill-pane');
	hiddenSkillPane.addClass('hidden');
	characterSkillPane.append(hiddenSkillPane);

	// skill list options :
	const skillPaneOptions = createCustomObject('div');
	skillPaneOptions.addClass('skill-list-options');
	characterSkillPane.append(skillPaneOptions);

	// -- skill options display toggler
	const skillOptDisplayToggler = createCustomObject('div');
	skillOptDisplayToggler.addClass('skill-opt-toggler');
	skillPaneOptions.append(skillOptDisplayToggler);

	// -- skill name filter
	const skillHiddenFilter = createCustomObject('div');
	skillHiddenFilter.attr('data', '');
	skillHiddenFilter.addClass('skill-opt-change');
	skillHiddenFilter.addClass('hidden');
	const skillFilter = createCustomObject('input');
	skillFilter.addClass('skill-filter-input');
	skillFilter.attr('type', 'text');
	skillFilter.on("change paste keyup", function() {
		var hiddenTrigger = $(this).parent().children('.hidden.skill-opt-change');
		hiddenTrigger.attr('data', $(this).val());
		hiddenTrigger.click();
	});
	skillPaneOptions.append(skillHiddenFilter);
	skillPaneOptions.append(skillFilter);

	// -- skill sort by name
	const skillSorterByAlpha = createCustomObject('div');
	skillSorterByAlpha.addClass('skill-sort-by-alpha');
	skillSorterByAlpha.addClass('skill-opt-change');
	skillPaneOptions.append(skillSorterByAlpha);

	// -- skill sort by value
	const skillSorterByValue = createCustomObject('div');
	skillSorterByValue.addClass('skill-sort-by-value');
	skillSorterByValue.addClass('skill-opt-change');
	skillPaneOptions.append(skillSorterByValue);

	// add skill nodes
	characterSkillPane.append(skillDisplayedNodes);
	characterSkillPane.append(skillRefNodes);

	return characterSkillPane;
}

function buildSkillWrapper(skill) {
	var skillWrapper = createCustomObject('div');
	skillWrapper.addClass('sheet-skill-display-wrapper');
	skillWrapper.attr('name', skill.name.toLowerCase());
	skillWrapper.attr('value', skill.value);

	var skillName = createCustomObject('div');
	skillName.addClass('name');
	skillName.addClass('macro');
	skillName.attr('data', skill.macro);
	skillName.html(skill.name);

	var skillValue = createCustomObject('div');
	skillValue.addClass('value');
	skillValue.addClass('macro');
	skillValue.attr('data', skill.macro);
	skillValue.html(skill.value >= 10 ? skill.value : '0'+skill.value);
	
	var skillBar = createCustomObject('div');
	skillBar.addClass('bar');
	skillBar.css('width', (skill.value/4.5)+'%');
	skillBar.css('opacity', (0.5 + 0.5*(skill.value)/100.0)+'');

	skillWrapper.append(skillName);
	skillWrapper.append(skillValue);
	skillWrapper.append(skillBar);
	return skillWrapper;
}

function computeMacro(str, options) {
	// set option values
	var value = replaceParameters(str, options);
	// eval expressions
	value = value.replace(/\[\[([a-zA-Z0-9\/\*\-\+\(\)]+)\]\]/g, function(_,k){
		var res = '[['+eval('Math.'+k)+']]';
		return res;
	});
	return value;
}
function replaceParameters(str, parameters) {
	return str.replace(/@{(\w+)}/g, function(_,k){
		return parameters.get(k) == null ? ('@{'+k+'}') : parameters.get(k);
	});
}
function replaceMacroTitle(str, value) {
	return str.replace(/\{\{title=([@\{\}\w+ ]+)\}\}/g, function(_,k){
		console.log('REPLACE::' + k + ' by ' + value);
		return '{{title='+value+'}}';
	});
}

//--------------------------------------------------------//
//------------ Custom sheets action listener ------------//
//--------------------------------------------------------//
function actionPerform(event) {
	var target = $(event.target);
	console.log('actionPerform::' + target.attr('class'));
	if(target.hasClass('macro')) {
		console.log('macro::' + target.attr('data'));
		console.log('macro>>' + computeMacro(target.attr('data'), macroOptionKeyMap));
		// launch macro
		showPinnedCharSheet(false);
		sendMsgByChat(computeMacro(target.attr('data'), macroOptionKeyMap), true);
	} else if(target.hasClass('macro-option')) {
		// change macro option
		macroOptionKeyMap.set(rollDifficultyKey, target.attr('value'));
	} else if(target.hasClass('toggle-display')) {
		var root = target.parents('.root');
		root.toggleClass('on');
	} else if(target.hasClass('open-dialog')) {
		// open dialog source
		var id = target.attr('data-characterid');
		openDialogSource(id);
	} else if(target.hasClass('drop-out')) {
		console.log('ACTION : drop-out');
		var id = target.attr('data-characterid');
		console.log('ACTION : drop-out id = ' + id);
		var miniDialog = createMiniFloatingSheet(id);
		$(document.body).append(miniDialog);
	} else if(target.hasClass('layout-change')) {
		var root = target.parents('.root');
		root.toggleClass('layout-alt');
	} else if(target.hasClass('put-all-to-hand')) {
		clearHand();
		var root = target.parents('.root');
		root.find('.put-to-hand').click();
	} else if(target.hasClass('put-to-hand')) {
		console.log('> put-to-hand');
		// put sheet to hand
		var id = target.attr('data-characterid');
		console.log('> id ' + id);
		var imageURL = target.attr('src-img');
		console.log('> imageURL ' + imageURL);
		putInHand(id, imageURL, function() {
			pinnCharacterSheet(id);
		});
	} else if(target.hasClass('pinn-sheet')) {
		var id = target.attr('data-characterid');
		console.log('listener : pinn-sheet ' + id);
		pinnCharacterSheet(id);
	} else if(target.hasClass('refresh-data')) {
		var id = target.attr('data-characterid');
		console.log('listener : refresh-data ' + id);
		refreshSheetData(id);
	} else if(target.hasClass('skill-opt-toggler')) {
		target.parent().toggleClass('on');
	} else if(target.hasClass('skill-opt-change')) {
		var skillPane = target.parents('.character-skill-pane');
		// skill filter/sort values
		var skillFilterValue = skillPane.find('.skill-filter-input').val();
		var skillSortMode = '';
		if (target.hasClass('skill-sort-by-alpha')) {
			target.toggleClass('on');
			skillPane.find('.skill-sort-by-value').removeClass('on');
		} else if (target.hasClass('skill-sort-by-value')) {
			target.toggleClass('on');
			skillPane.find('.skill-sort-by-alpha').removeClass('on');
		}
		if (skillPane.find('.skill-sort-by-alpha').hasClass('on')) {
			skillSortMode = 'alpha';
		} else if (skillPane.find('.skill-sort-by-value').hasClass('on')) {
			skillSortMode = 'value';
		}
		// update node list
		console.log('skill-opt-change : skillPane > ' + skillPane.length);
		console.log('skill-opt-change : skillFilter-input > ' + skillPane.find('.skill-filter-input').length);
		console.log('skill-opt-change : skillSort-by-alpha > ' + skillPane.find('.skill-sort-by-alpha').length);
		console.log('skill-opt-change : skillSort-by-value > ' + skillPane.find('.skill-sort-by-value').length);
		console.log('skill-opt-change : skillFilter-value ' + skillFilterValue);
		console.log('skill-opt-change : skillSort-mode ' + skillSortMode);
		filterAndSortNodes(skillPane, '.sheet-skill-display-wrapper', skillFilterValue, skillSortMode);
		skillPane.children('.bottom-resizer').detach().appendTo(skillPane);
	}
}
pinnedSheet.click(actionPerform);



function openDialogSource(id) {
	console.log('openDialogSource::' + id);
	// dialog source
	$('#journalfolderroot .character[data-itemid="'+id+'"]').click();
}
function filterAndSortNodes(root, selector, filterValue, sortMode) {
	console.log('filterAndSortNodes : A');
	root.children(selector+':not(.ref)').remove();
	root.children(selector+':not(.ref)').each(function() {
		console.log('remove : ' + $(this).attr('class'));
	});
	var nodes = root.children(selector+'.ref').clone(true);
	nodes.removeClass('hidden');
	nodes.removeClass('ref');
	console.log('nodes length : ' + nodes.length);

	// filtering
	var filterFct = buildFilterFuction(filterValue);
	if (filterFct != null) {
		nodes = nodes.filter(filterFct);
	}

	// sort
	switch (sortMode) {
		case 'alpha':
			nodes = nodes.sort(sortByAlpha);
			break;
		case 'value':
			nodes = nodes.sort(sortByValue);
			break;
		default:
			break;
	}
	
	root.append(nodes);
}
function buildFilterFuction(filterValue) {
	return filterValue == null || !filterValue ? null : function() {
		var node = $(this);
		console.log('node : ' + node.attr('class'));
		if(!node.attr('name').includes(filterValue.toLowerCase())) {
			return false;
		}
		return true;
	};
}
function sortByAlpha(skillA, skillB) {
	return skillA.getAttribute('name').localeCompare(skillB.getAttribute('name'));
}
function sortByValue(skillA, skillB) {
	return skillB.getAttribute('value') - skillA.getAttribute('value');
}

// TODO : filtre par skill de combat/arme à feu + filtre par check
