
console.log('CME-----------------------> misc-tools');

//------------------------------------------------------------//
//---------- Send data via Chat (image & sound) --------------//
//------------------------------------------------------------//
const MSG_PREFIX_IMG_BG = 'img-bg=';
const MSG_PREFIX_MEDIA_YT = 'yt=';

var inputDiv = document.getElementById('textchat-input');
var chatTextArea = inputDiv.children[1];
var chatBtn = inputDiv.lastElementChild;
function sendDataByChat(url) {
	if(url) {
		// file type:
		if(url.indexOf('.jpg') >= 0
				  || url.indexOf('.jpeg') >= 0
				  || url.indexOf('.png') >= 0
				  || url.indexOf('.bmp') >= 0) {
			chatTextArea.value = MSG_PREFIX_IMG_BG + btoa(url);
		} else if(url.indexOf('www.youtube.com') >= 0) {
			chatTextArea.value = MSG_PREFIX_MEDIA_YT + btoa(url);
		}
		chatBtn.click();
	}
};
function sendMsgByChat(msg, showChat) {
	if(!msg) {
		return;
	}
	chatTextArea.value = msg;
	chatBtn.click();
	console.log('showChat : ' + showChat);
	if(showChat && showChat != null) {
		var index = $('#rightsidebar > ul.tabmenu a[href="#textchat"]').parent().index();
		$('#rightsidebar').tabs({
		  active: index
		});
		$('#character-pannel').removeClass('on');
		$('#character-sheet-button').removeClass('on');
		$('#textchat-input').removeClass('hidden-pane');
		$('#textchat-input').css('display', 'block');
		console.log('INDEX chat !');
	}
}

var sentDataBtn = createCustomElement('div', 'data-sender');
sentDataBtn.onclick = function() {
	var url = prompt("URL du fichier :", "");
	sendDataByChat(url);
};
inputDiv.insertBefore(sentDataBtn, inputDiv.lastElementChild);


//--------------------------------------------------------------------------------//
//---------- Add context menu to library items to change backgrouns --------------//
//--------------------------------------------------------------------------------//
const intervalCtxtMenuTool = 1000;
const addCtxtMenuTool = () => {
	if(!isChatInit) {
		setTimeout(addCtxtMenuTool, intervalCtxtMenuTool);
		return;
	}
	// add action into context menu
	var src;
	
	var sendImgItemMenu = createCustomElement('li');
	sendImgItemMenu.innerHTML = 'Background';

	var ctxtMenu1 = document.getElementById('libraryitemmenu');
	var sendImgItemMenu1 = sendImgItemMenu.cloneNode(true);
	sendImgItemMenu1.addEventListener("mousedown", () => {
		ctxtMenu1.style.display = 'none';
		sendDataByChat(src);
	}, false);
	sendImgItemMenu1.style.display = 'none';
	ctxtMenu1.children[0].appendChild(sendImgItemMenu1);

	var ctxtMenu2 = document.getElementById('librarycopymenu');
	var sendImgItemMenu2 = sendImgItemMenu.cloneNode(true);
	sendImgItemMenu2.addEventListener("mousedown", () => {
		ctxtMenu2.style.display = 'none';
		sendDataByChat(src);
	}, false);
	sendImgItemMenu2.style.display = 'none';
	ctxtMenu2.children[0].appendChild(sendImgItemMenu2);

	var ctxtMenu3 = document.getElementById('libraryviewmenu');
	var sendImgItemMenu3 = sendImgItemMenu.cloneNode(true);
	sendImgItemMenu3.addEventListener("mousedown", () => {
		ctxtMenu3.style.display = 'none';
		sendDataByChat(src);
	}, false);
	sendImgItemMenu3.style.display = 'none';
	ctxtMenu3.children[0].appendChild(sendImgItemMenu3);
	
	var findTargetImgLib = (event) => {
		sendImgItemMenu1.style.display = 'none';
		sendImgItemMenu2.style.display = 'none';
		sendImgItemMenu3.style.display = 'none';
		var target = event.target;
		while (	!target.id 
				|| target.id == null
				|| target.id != 'libraryfolderroot'
				|| target.id != 'recentuploads'
				|| target.id != 'libraryview') {
			if (target.tagName == 'LI' || target.classList && target.classList.contains('library-container')) {
				src = target.getAttribute('data-fullsizeurl');
				sendImgItemMenu1.style.display = 'block';
				sendImgItemMenu2.style.display = 'block';
				sendImgItemMenu3.style.display = 'block';
				return;
			}
			target = target.parentNode;
		}
	}
	document.getElementById('libraryfolderroot').addEventListener("contextmenu", findTargetImgLib);
	document.getElementById('recentuploads').addEventListener("contextmenu", findTargetImgLib);
	document.getElementById('libraryview').addEventListener("contextmenu", findTargetImgLib);
	
	// add observer on chat content
}
setTimeout(addCtxtMenuTool, intervalCtxtMenuTool);



console.log("Starting up WEB WORKER");

