
//------------------------------------------------//
//---------- Image screen MJ control -------------//
//------------------------------------------------//
function onUserStatusKnown() {
	menu_content.innerHTML = '';
	if (!isGM) {
		menu_content.style.display = 'none';
	} else {
		const screenItemCtrlPanel = createCustomElement('div');
		screenItemCtrlPanel.id = 'screen-item-control-panel';
		screenItemCtrlPanel.style.background = '#333';
		screenItemCtrlPanel.style.height = 'calc(100vh - 100px)';
		screenItemCtrlPanel.style.opacity = '0.9';
		menu_content.appendChild(screenItemCtrlPanel);

		var circleToggleBtn = createCustomElement('button');
		circleToggleBtn.id = 'circle-toggle-btn';
		var wideHideBtn = createCustomElement('button');
		wideHideBtn.id = 'wide-hide-btn';
		var addBtn = createCustomElement('button');

		// retrieve stored images
		var screenImages = localStorage.getItem("screenImages");
		if (!screenImages) {
			screenImages=`[]`;
		}
		screenImages = JSON.parse(screenImages);

		function addImageControl(url) {
			const imgDiv = createCustomElement('div');
			imgDiv.style.display = 'inline-block';
			imgDiv.style.height = '120px';
			imgDiv.style.position = 'relative';
			imgDiv.padding = '0';
			imgDiv.margin = '0';
			const img = createCustomElement('img');
			img.classList.add("screen-item-img");
			img.src = url;
			img.style.height = "100%";
			img.style.cursor = 'pointer';
			img.ondblclick = () => {
				sendDataByChat(url, 'circle');
			};

			// remove image button
			const removeBtn = createCustomElement('img');
			removeBtn.src = 'http://www.sda-campagne.fr/misc/greek_theme/remove_cross.png';
			removeBtn.style.position = 'absolute';
			removeBtn.style.left = '2px';
			removeBtn.style.bottom = '2px';
			removeBtn.style.opacity = '0';
			removeBtn.style.cursor = 'pointer';
			removeBtn.style.background = '#333';
			removeBtn.style.borderRadius = '50%';
			removeBtn.onmouseenter = () => {
				removeBtn.style.background = '#111';
			};
			removeBtn.onmouseleave = () => {
				removeBtn.style.background = '#333';
			};
			removeBtn.onclick = () => {
				if(confirm("Are you want remove this image ?")) {
					screenItemCtrlPanel.removeChild(imgDiv);
					screenImages = screenImages.filter((e) => {
						console.log(e+' ? '+ (e != url));
						return e != url;
					});
					// save data
					localStorage.setItem("screenImages", JSON.stringify(screenImages));
				}
			};

			// show large image button
			const widerBtn = createCustomElement('img');
			widerBtn.src = 'http://www.sda-campagne.fr/misc/greek_theme/expand_icon.png';
			widerBtn.style.position = 'absolute';
			widerBtn.style.right = '2px';
			widerBtn.style.bottom = '2px';
			widerBtn.style.opacity = '0';
			widerBtn.style.cursor = 'pointer';
			widerBtn.style.background = '#333';
			widerBtn.onmouseenter = () => {
				widerBtn.style.background = '#111';
			};
			widerBtn.onmouseleave = () => {
				widerBtn.style.background = '#333';
			};
			widerBtn.onclick = () => {
				sendDataByChat(url, 'wide');
			};

			// show large image button
			const asContextBtn = createCustomElement('img');
			asContextBtn.src = 'http://www.sda-campagne.fr/misc/greek_theme/pin_icon.png';
			asContextBtn.style.position = 'absolute';
			asContextBtn.style.right = '2px';
			asContextBtn.style.top = '2px';
			asContextBtn.style.opacity = '0';
			asContextBtn.style.cursor = 'pointer';
			asContextBtn.style.background = '#333';
			asContextBtn.onmouseenter = () => {
				widerBtn.style.background = '#111';
			};
			asContextBtn.onmouseleave = () => {
				widerBtn.style.background = '#333';
			};
			asContextBtn.onclick = () => {
				var data ={};
				data.id = prompt("Give a context data name:");
				if (!data.id) {
					data.id = '?';
				}
				data.img = url;
				//sendSimpleImgContext(data);
				addContextCard(data, true);
			};

			imgDiv.onmouseover = () => {
				removeBtn.style.opacity = '0.8';
				widerBtn.style.opacity = '0.8';
				asContextBtn.style.opacity = '0.8';
			};
			imgDiv.onmouseout = () => {
				removeBtn.style.opacity = '0';
				widerBtn.style.opacity = '0';
				asContextBtn.style.opacity = '0';
			};

			imgDiv.appendChild(img);
			imgDiv.appendChild(removeBtn);
			imgDiv.appendChild(widerBtn);
			imgDiv.appendChild(asContextBtn);
			screenItemCtrlPanel.appendChild(imgDiv);
		}

		// 'circle toggle' button settings
		var isCircleDisplayed = false;
		circleToggleBtn.style.height = '90px';
		circleToggleBtn.style.width = '70px';
		circleToggleBtn.style.borderRadius = '40%';
		circleToggleBtn.style.background = '#333';
		circleToggleBtn.style.backgroundSize = 'cover';
		circleToggleBtn.style.backgroundPosition = 'center center';
		circleToggleBtn.style.backgroundImage = circleView.style.backgroundImage;
		circleToggleBtn.style.borderWidth = '5px';
		circleToggleBtn.style.color = '#ddd';
		circleToggleBtn.style.position = 'absolute';
		circleToggleBtn.style.top = '0';
		circleToggleBtn.style.left = '0';
		circleToggleBtn.style.transform = 'translateX(-100%) translateY(70px)';
		circleToggleBtn.style.textShadow = '2px 0 0 #000, -2px 0 0 #000, 0 2px 0 #000, 0 -2px 0 #000, 1px 1px #000, -1px -1px 0 #000, 1px -1px 0 #000, -1px 1px 0 #000';
		circleToggleBtn.style.boxShadow = '0 0 25px black inset, 0 0 25px black inset';
		circleToggleBtn.style.zIndex = '5';
		circleToggleBtn.innerHTML = 'Show Circle';
		circleToggleBtn.onclick = () => {
			isCircleDisplayed = !isCircleDisplayed;
			sendDataByChat(isCircleDisplayed ? 'on' : 'off', 'circle');
		};
		screenItemCtrlPanel.appendChild(circleToggleBtn);

		// 'hide wide-image' button settings
		wideHideBtn.style.height = '90px';
		wideHideBtn.style.width = '70px';
		wideHideBtn.style.background = '#333';
		wideHideBtn.style.backgroundSize = 'cover';
		wideHideBtn.style.backgroundPosition = 'center center';
		wideHideBtn.style.backgroundImage = circleView.style.backgroundImage;
		wideHideBtn.style.borderWidth = '5px';
		wideHideBtn.style.color = '#ddd';
		wideHideBtn.style.position = 'absolute';
		wideHideBtn.style.top = '0';
		wideHideBtn.style.left = '0';
		wideHideBtn.style.transform = 'translateX(-100%)';
		wideHideBtn.style.textShadow = '2px 0 0 #000, -2px 0 0 #000, 0 2px 0 #000, 0 -2px 0 #000, 1px 1px #000, -1px -1px 0 #000, 1px -1px 0 #000, -1px 1px 0 #000';
		wideHideBtn.style.boxShadow = '0 0 25px black inset, 0 0 25px black inset';
		wideHideBtn.innerHTML = 'Hide Back';
		wideHideBtn.onclick = () => {
			sendDataByChat('off', 'wide');
		};
		screenItemCtrlPanel.appendChild(wideHideBtn);

		// 'add image' button settings
		addBtn.style.height = '70px';
		addBtn.style.width = '70px';
		addBtn.style.background = 'rgb(36, 84, 100)';
		addBtn.style.borderWidth = '5px';
		addBtn.style.color = '#ddd';
		addBtn.style.position = 'absolute';
		addBtn.style.top = '0';
		addBtn.style.right = '0';
		addBtn.style.transform = 'translateX(100%)';
		addBtn.style.boxShadow = '0 0 25px black inset, 0 0 25px black inset';
		addBtn.innerHTML = 'Add';
		addBtn.onclick = () => {
			var url = prompt("URL de l'image :", "");
			// add img
			addImageControl(url);
			// save data
			screenImages.push(url);
			localStorage.setItem("screenImages", JSON.stringify(screenImages));

		};
		screenItemCtrlPanel.appendChild(addBtn);

		// add images to control panel
		for(const screenImg of screenImages) {
			addImageControl(screenImg);
		}
	}
}
/*
// GME global menu
gmeMenu = createCustomElement('div');
gmeMenu.id = 'gme-config-menu';
gmeMenuItem_r20WrapperToggler = createCustomElement('div');
gmeMenuItem_r20WrapperToggler.id = 'gme-r20-wrapper-toggler';
gmeMenuItem_r20WrapperToggler.onclick = () => {
	let wrapper = document.getElementById('editor-wrapper');
	let pageToolbar = document.getElementById('page-toolbar');
	let zoomslider = document.getElementById('zoomslider');
	if(wrapper.classList.contains("undisplayedChildren")) {
		wrapper.classList.remove('undisplayedChildren');
		pageToolbar.classList.remove('undisplayed');
		zoomslider.classList.remove('undisplayed');
	} else {
		wrapper.classList.add('undisplayedChildren');
		pageToolbar.classList.add('undisplayed');
		zoomslider.classList.add('undisplayed');
	}
}
gmeMenuItem_r20PlayerzoneToggler = createCustomElement('div');
gmeMenuItem_r20PlayerzoneToggler.id = 'gme-r20-playerzone-toggler';
gmeMenuItem_r20PlayerzoneToggler.onclick = () => {
	let playerzone = document.getElementById('playerzone');
	if(playerzone.classList.contains("undisplayed")) {
		playerzone.classList.remove('undisplayed');
	} else {
		playerzone.classList.add('undisplayed');
	}
}

gmeMenu.appendChild(gmeMenuItem_r20WrapperToggler);
gmeMenu.appendChild(gmeMenuItem_r20PlayerzoneToggler);
document.body.appendChild(gmeMenu);
*/