//-----------------------------------
//---------- cards data -------------
//-----------------------------------

const cardsStr=`[
{
"id":"adonis",
"type":"Personnages",
"title":"Adonis",
"desc":"Adonis, enfant d'Appolon. ",
"img":"http://www.sda-campagne.fr/misc/greek_theme/data/Adonis.jpg"
},
{
"id":"nikos",
"type":"Personnages",
"title":"Nikos",
"desc":"Nikos... ",
"img":"http://www.sda-campagne.fr/misc/greek_theme/data/Nikos.jpg"
},
{
"id":"argurios",
"type":"Personnages",
"title":"Argurios",
"desc":"Argurios, protégé d'Athéna. ",
"img":"http://www.sda-campagne.fr/misc/greek_theme/data/Argurios.jpg"
},
{
"id":"athena",
"type":"Panthéon",
"title":"Athena",
"desc":"Athéna est la déesse grecque de la sagesse, de la stratégie guerrière, de la justice et du combat mais aussi la déesse protectrice des artisans et de la cité d'Athènes. C'est la fille de Zeus et de Métis. ",
"img":"http://www.sda-campagne.fr/misc/greek_theme/data/Athena.jpg"
},
{
"id":"hecate",
"type":"Panthéon",
"title":"Hécate",
"desc":"<p>Fille de <b>Persès</b> et <b>Astéria</b>, la titanide Hécate appartient à la première génération des dieux. Crainte et respectée par tous, elle dispense richesses et victoires aux mortelles comme aux immortels. </p><p>Hécate fait partie de la Triade Lunaire, avec <b>Séléné</b> et <b>Artémis</b> : Hécate représente la nouvelle lune ou lune noire, qui symbolise la mort. </p><p>Hécate présente deux aspects opposés : déesse protectrice liée aux cultes de la fertilité, accordant richesse matérielle et spirituelle, honneurs et sagesse, conductrice des âmes emportées par la tempête; mais aussi déesse de l'ombre et des morts.</p><p>Déesse nocturne et magique, elle préside aux enchantements et aux incantations. Elle est une fidèle compagne de <b>Perséphone</b> depuis qu'elle aida sa mère <b>Déméter</b> à la retrouver.</p>",
"img":"http://www.sda-campagne.fr/misc/greek_theme/data/hecate.jpg"
},
{
"id":"hellen",
"type":"Héros",
"title":"Hellen",
"desc":"<p>Fils de <b>Deucalion</b> et de <b>Pyrrha</b>, seuls survivants du déluge de Zeus, Hellen fut roi de Phthie en Thessalie.</p>On lui attribue trois fils, <b>Doros</b>, <b>Eole</b> et <b>Xouthos</b>, nés de la nymphe <b>Orséis</b>. Il est regardé par tout les grecs comme leur père. De Doros et Eole sont issus les Doriens et les Eoliens. Quant aux deux fils de Xouthos, <b>Achaeos</b> et <b>Ion</b>, ils engendrèrent les Achéens et les Ioniens."
},
{
"id":"athenes",
"type":"Atlas",
"title":"Athènes",
"desc":"Ville sous la protection d'<b>Athéna</b>. ",
"img":"http://www.sda-campagne.fr/misc/greek_theme/data/athenes.jpg"
}
]`;

localStorage.setItem("data", cardsStr);

localStorage.setItem("cards", JSON.stringify([ "adonis", "nikos", "argurios", "athena", "hecate", "hellen", "athenes" ]));

//-----------------------------------------------//
//---------- cards menu & containers ------------//
//-----------------------------------------------//
var hand = createCustomElement('div');
hand.id = 'hand';
document.body.appendChild(hand);

var handExpanderHandler = createCustomElement('div');
handExpanderHandler.id = 'hand-expander-handler';
hand.appendChild(handExpanderHandler);
var handRight = createCustomElement('div');
handRight.id = 'hand-right';
document.body.appendChild(handRight);
var expanded = false;
function expandTable(expand) {
	if(expand) {
		hand.style.height = '280px';
	} else {
		hand.style.height = '120px';
	}
	expanded = expand;
}
handExpanderHandler.onclick = () => {
	expandTable(!expanded);
}

// -- menu bottom left
var handMenubarLeft = createCustomElement('ul');
handMenubarLeft.id = 'hand-menubar-left';
hand.appendChild(handMenubarLeft);

// -- menu bottom right
var handMenubarRight = createCustomElement('ul');
handMenubarRight.id = 'hand-menubar-right';
hand.appendChild(handMenubarRight);

// -- table
var handContainer = createCustomElement('ul');
handContainer.id = 'table-cards';
hand.appendChild(handContainer);

// -- context
var contextContainer = createCustomElement('ul');
contextContainer.id = 'context-cards';
hand.appendChild(contextContainer);
var contextContainerActive = createCustomElement('ul');
contextContainerActive.id = 'context-cards-active';
document.body.appendChild(contextContainerActive);


setAsDropContainer(hand, (droppedElt, onDropOut) => {
	addCardDroppedCard(droppedElt, contextContainer, onDropOut);
});

//-----------------------------------
//---------- cards data -------------
//-----------------------------------

function addCardDroppedCard(droppedElt, destParent, onDropOut) {
	const oldParent = droppedElt.parentNode;
	const droppedClass = 'as-dropped-card';

	// create new card
	var card = createCustomElement('li');
	card.classList.add('dropped-card');
	card.style.position = 'relative';
	card.appendChild(droppedElt);
	card.onmouseenter = () => {
		new Audio('http://sda-campagne.fr/assets/sound/page-turn.wav').play();
	};
	card.onclick = () => {
		card.classList.toggle('active');
	};
	card.ondblclick = () => {
		console.log('droppedElt: ' + droppedElt.id);
		console.log('card: ' + card.tagName + '.' + card.id);
		console.log('oldParent: ' + oldParent.tagName + '.' + oldParent.id);
		console.log('destParent: ' + destParent.id);
		// remove card & back to old parent
		droppedElt.classList.remove(droppedClass);
		oldParent.appendChild(droppedElt);
		droppedElt.style.left = 'calc(50% - 155px)';
		droppedElt.style.top = '40%';
		destParent.removeChild(card);

		if(onDropOut) {
		   onDropOut();
		}
	};

	droppedElt.classList.add(droppedClass);
	destParent.appendChild(card);
}
function addCard(data, parent) {
	console.log('addCard ' + data.id);
	var card = createCustomElement('li');
	card.classList.add('ripple');
	if(data.img) {
		card.style.backgroundImage = 'url("' + data.img + '")';
	} else {
		card.style.backgroundImage = 'url("http://www.sda-campagne.fr/misc/greek_theme/data/default_card.jpg")';
	}
	if(data.id) {
		card.innerHTML = data.title ? data.title : data.id;
	}
	card.onmouseover = () => {
		if(card.parentNode.id !== contextContainerActive.id) {
			new Audio('http://sda-campagne.fr/assets/sound/page-turn.wav').play();
		}
	};
	card.onclick = () => {
		console.log('card.onclick...');
		console.log('card.onclick: ' + data);
		console.log('card.onclick: ' + JSON.stringify(data));
		displayDetailsData(data);
		if(card.parentNode.id === contextContainerActive.id) {
			card.style.opacity = '0';
			setTimeout(() => {
				contextContainer.appendChild(card);
				card.classList.toggle('active');
				card.style.opacity = '';
				setTimeout(() => {
					card.classList.toggle('active');
				}, 1000);
				checkContextCardVisibility();
			}, 100);
		} else {
			card.classList.toggle('active');
		}
	};
	parent.appendChild(card);
	if (parent.id === contextContainerActive.id) {
		checkContextCardVisibility();
	}
}
function checkContextCardVisibility() {
	if(contextContainerActive.hasChildNodes()) {
		console.log('hasChildNodes');
		contextContainerActive.style.display = 'block';
	} else {
		console.log('NOT hasChildNodes');
		contextContainerActive.style.display = 'none';
	}
}

function addContextCard(data, active) {
	addCard(data, active ? contextContainerActive : contextContainer);
}
function addTableCard(data) {
	console.log('addTableCard ' + data.id);
	addCard(data, handContainer);
}
function cleanCardTable() {
	handContainer.innerHTML='';
}
function displayTableCards(cardType) {
		console.log('displayTableCards...');
	cleanCardTable();
	console.log('cardType' + cardType);
	// parse cards owned
	var cards = localStorage.getItem("cards");
	cards = JSON.parse(cards);
	var dataCardList = localStorage.getItem("data");
	dataCardList = JSON.parse(dataCardList);
	dataCardList.filter(data => {
		console.log(data.id + ' check ?' + data.type + ' => ' + ((cards.indexOf(data.id) >= 0) && (data.type === cardType)));
		return (cards.indexOf(data.id) >= 0) && (data.type === cardType);
	}).forEach(addTableCard);
}



//------------------------------------------
//------------ bottom menu bar -------------
//------------------------------------------

function selectMenuItem(selection) {
	console.log('cleanMenuSelection BEGIN');
	for (var menuItem1 of handMenubarLeft.children) {
		console.log('menuItem:' + menuItem1);
		menuItem1.classList.remove('selected');
	}
	for (var menuItem2 of handMenubarRight.children) {
		console.log('menuItem:' + menuItem2);
		menuItem2.classList.remove('selected');
	}
	selection.classList.add('selected');
	expandTable(true);
	console.log('cleanMenuSelection END');
}

// ---- Left: Personnages
var menuItemPersonnages = createCustomElement('li');
menuItemPersonnages.id = 'menu-item-personnages';
menuItemPersonnages.innerHTML = 'Personnages';
menuItemPersonnages.onclick = () => {
  selectMenuItem(menuItemPersonnages);
  displayTableCards(menuItemPersonnages.innerHTML);
};
handMenubarLeft.appendChild(menuItemPersonnages);
// ---- Left: Notes
var menuItemNotes = createCustomElement('li');
menuItemNotes.id = 'menu-item-notes';
menuItemNotes.innerHTML = 'Notes';
menuItemNotes.onclick = () => {
  selectMenuItem(menuItemNotes);
  displayTableCards(menuItemNotes.innerHTML);
};
handMenubarLeft.appendChild(menuItemNotes);
// ---- Left: Atlas
var menuItemAtlas = createCustomElement('li');
menuItemAtlas.id = 'menu-item-atlas';
menuItemAtlas.innerHTML = 'Atlas';
menuItemAtlas.onclick = () => {
  selectMenuItem(menuItemAtlas);
  displayTableCards(menuItemAtlas.innerHTML);
};
handMenubarLeft.appendChild(menuItemAtlas);

// ---- Right: Panthéon
var menuItemPantheon = createCustomElement('li');
menuItemPantheon.id = 'menu-item-pantheon';
menuItemPantheon.innerHTML = 'Panthéon';
menuItemPantheon.onclick = () => {
  selectMenuItem(menuItemPantheon);
  displayTableCards(menuItemPantheon.innerHTML);
};
handMenubarRight.appendChild(menuItemPantheon);
// ---- Right: Héros
var menuItemHeros = createCustomElement('li');
menuItemHeros.id = 'menu-item-heros';
menuItemHeros.innerHTML = 'Héros';
menuItemHeros.onclick = () => {
  selectMenuItem(menuItemHeros);
  displayTableCards(menuItemHeros.innerHTML);
};
handMenubarRight.appendChild(menuItemHeros);
// ---- Right: Mythes
var menuItemMythes = createCustomElement('li');
menuItemMythes.id = 'menu-item-heros';
menuItemMythes.innerHTML = 'Mythes';
menuItemMythes.onclick = () => {
  selectMenuItem(menuItemMythes);
  displayTableCards(menuItemMythes.innerHTML);
};
handMenubarRight.appendChild(menuItemMythes);


