
// ------------- Character Sheet custom ------------ //

class SelectableWidget {
	constructor(parent, name, value) {
		this.model = { name: name, value: value };
		this.buildUI(parent);
	}
	toggle() {
		this.ui.classList.toggle('selected');
	}
	select() {
		this.ui.classList.add('selected');
	}
	unselect() {
		this.ui.classList.remove('selected');
	}
	update(value) {
		this.model.value = value;
		this.valueUI.innerHTML = this.model.value;
	}
	buildUI(parent) {
		var ui = createCustomElement('div');
		var titleUI = createCustomElement('div');
		var valueUI = createCustomElement('div');

		ui.classList.add('char-sheet-selectable');
		titleUI.classList.add('char-sheet-title');
		valueUI.classList.add('char-sheet-value');

		titleUI.innerHTML = this.model.name;
		valueUI.innerHTML = this.model.value;

		ui.appendChild(titleUI);
		ui.appendChild(valueUI);
		parent.appendChild(ui);

		this.ui = ui;
		this.valueUI = valueUI;
	}
	dispose() {
		if(this.ui.parentNode) {
			this.ui.parentNode.removeChild(this.ui);
		}
	}
}

var sheetRegister = new Map();
class characterSheet {
	constructor() {
		this.uiSelectionModel = {}; // selection ui model
		this.rollModel = {}; // dice roll model
		this.storage = { ui: null, minimizedUI: null};
	}

	setCharacter(character) {
		if (character) {
			this.key = character.nom;
			sheetRegister.set(this.key, this);
			if(!this.character) {
				this.character = character;
				this.initUI();
			} else {
				this.character = character;
				this.updateUI();
			}
		}
	}

	initUI() {
		// container
		const container = createCustomElement('div');
		container.id = 'character-sheet-ui';
		container.setAttribute('draggable', true);

		// row 1 : character data
		const row1 = createCustomElement('div');
		row1.classList.add('character-sheet-row');

		// row 1 column 1 : Name + Image
		const r1c1 = createCustomElement('div');
		const storage = this.storage;
		r1c1.ondblclick = () => {
			this.toggleMinimized();
		};
		//r1c1.onclick = displayPJChooser;
		r1c1.classList.add('character-sheet-column');
		// -- image
		const r1c1Image = createCustomElement('div');
		r1c1Image.classList.add('character-sheet-image');
		if (this.character.image) {
			r1c1Image.style.backgroundImage = 'url(\'' + this.character.image + '\')';
		}
		// -- name
		const r1c1Title = createCustomElement('div');
		r1c1Title.classList.add('character-sheet-title');
		r1c1Title.innerHTML = this.character.nom;
		// -- close button
		const closeBtn = createCustomElement('div');
		closeBtn.classList.add('btn-close-sheet');
		closeBtn.onclick = () => {
			this.dispose();
		};

		this.nameUI = r1c1Title;
		this.imageUI = r1c1Image;
		r1c1Image.appendChild(r1c1Title);
		r1c1Image.appendChild(closeBtn);
		r1c1.appendChild(r1c1Image);

		// row 1 column 2 : Attributs
		const r1c2 = createCustomElement('div');
		r1c2.classList.add('character-sheet-column');
		// -- title : Attributs
		const r1c2Title = createCustomElement('p');
		r1c2Title.classList.add('character-sheet-subtitle');
		r1c2Title.innerHTML = 'ATTRIBUTS';
		r1c2.appendChild(r1c2Title);
		// -- valeurs
		this.vigueurUI = this.buildAttributUI(r1c2, 'Vigueur' , this.character.attributs.vigueur);
		this.agiliteUI = this.buildAttributUI(r1c2, 'Agilité' , this.character.attributs.agilite);
		this.espritUI  = this.buildAttributUI(r1c2, 'Esprit' ,  this.character.attributs.esprit);
		this.auraUI    = this.buildAttributUI(r1c2, 'Aura' ,    this.character.attributs.aura);

		// row 1 column 3 : Carrieres
		const r1c3 = createCustomElement('div');
		r1c3.classList.add('character-sheet-column');
		// -- title : Carrieres
		const r1c3Title = createCustomElement('p');
		r1c3Title.classList.add('character-sheet-subtitle');
		r1c3Title.innerHTML = 'CARRIERES';
		r1c3.appendChild(r1c3Title);
		// -- valeurs
		this.carrieresUIList = [];
		for (var carriere of this.character.carrieres) {
			this.carrieresUIList.push(this.buildSkillUI(r1c3, carriere.nom , carriere.score));
		}
		this.carrieresUI = r1c3;

		// row 1 column 4 : Combat
		const r1c4 = createCustomElement('div');
		r1c4.classList.add('character-sheet-column');
		// -- title : Combat
		const r1c4Title = createCustomElement('p');
		r1c4Title.classList.add('character-sheet-subtitle');
		r1c4Title.innerHTML = 'COMBAT';
		r1c4.appendChild(r1c4Title);
		this.initiativeUI = this.buildSkillUI(r1c4, 'Initiative' , this.character.combat.initiative);
		this.meleeUI      = this.buildSkillUI(r1c4, 'Mêlée' ,      this.character.combat.melee);
		this.tirUI        = this.buildSkillUI(r1c4, 'Tir' ,        this.character.combat.tir);
		this.defenseUI    = this.buildSkillUI(r1c4, 'Défense' ,    this.character.combat.defense);

		// row 2 : difficulty dice roll
		const row2 = createCustomElement('div');
		row2.classList.add('character-sheet-adv-row');
		this.modifUI = row2;

		const r2c1 = this.buildDifficultyBtn('Très Facile', 2);
		const r2c2 = this.buildDifficultyBtn('Facile', 1);
		const r2c3 = this.buildDifficultyBtn('Normal', 0);
		const r2c4 = this.buildDifficultyBtn('Ardue', -1);
		const r2c5 = this.buildDifficultyBtn('Difficile', -2);
		const r2c6 = this.buildDifficultyBtn('Très difficile', -4);
		const r2c7 = this.buildDifficultyBtn('Impossible', -6);
		const r2c8 = this.buildDifficultyBtn('Héroïque', -8);

		// expander to see advanced data
		const sheetExpander = createCustomElement('div');
		sheetExpander.classList.add('sheet-expander');
		sheetExpander.onclick = () => {
			container.classList.toggle('expanded');
		};

		// Advanced data
		const advancedData = createCustomElement('div');
		advancedData.classList.add('adv-data');

		// 1: Health + Heoric points + Ubris
		const advDataPoints = createCustomElement('div');
		advDataPoints.classList.add('adv-data-points');

		const healthUI = createCustomElement('div');
		healthUI.classList.add('adv-data-points-value');
		healthUI.innerHTML = this.character.vitalite;

		const heroicUI = createCustomElement('div');
		heroicUI.classList.add('adv-data-points-value');
		heroicUI.innerHTML = this.character.heroisme;

		const ubrisUI = createCustomElement('div');
		ubrisUI.classList.add('adv-data-points-value');
		ubrisUI.innerHTML = ('demesure' in this.character) ? this.character.demesure : '0';

		const advancedDataBorder = createCustomElement('div');
		advancedDataBorder.classList.add('adv-data-points-bar-right');

		advDataPoints.appendChild(healthUI);
		advDataPoints.appendChild(heroicUI);
		advDataPoints.appendChild(ubrisUI);
		advDataPoints.appendChild(advancedDataBorder);

		// 2: Advanced menu
		const advDataMenu = createCustomElement('div');
		advDataMenu.classList.add('adv-data-menu');

		const advDataMenuTop = createCustomElement('div');
		advDataMenuTop.classList.add('adv-data-menu-top');

		const advDataMenuEquipement = createCustomElement('div');
		advDataMenuEquipement.classList.add('adv-data-menu-top-item');
		advDataMenuEquipement.classList.add('ripple');
		advDataMenuEquipement.innerHTML = 'Equipement';
		const advDataMenuAvantages = createCustomElement('div');
		advDataMenuAvantages.classList.add('adv-data-menu-top-item');
		advDataMenuAvantages.classList.add('ripple');
		advDataMenuAvantages.innerHTML = 'Avantages';
		const advDataMenuDesavantages = createCustomElement('div');
		advDataMenuDesavantages.classList.add('adv-data-menu-top-item');
		advDataMenuDesavantages.classList.add('ripple');
		advDataMenuDesavantages.innerHTML = 'Désavantages';
		const advDataMenuPouvoir = createCustomElement('div');
		advDataMenuPouvoir.classList.add('adv-data-menu-top-item');
		advDataMenuPouvoir.classList.add('ripple');
		advDataMenuPouvoir.innerHTML = 'Pouvoirs';
		const advDataMenuHistoire = createCustomElement('div');
		advDataMenuHistoire.classList.add('adv-data-menu-top-item');
		advDataMenuHistoire.classList.add('ripple');
		advDataMenuHistoire.innerHTML = 'Histoire';

		const advDataMenuContainer = createCustomElement('div');
		advDataMenuContainer.classList.add('adv-data-container');

		// -- avantages
		const avantagesPane = createCustomElement('div');
		avantagesPane.classList.add('avantage-pane');
		for (var avantage of this.character.avantage) {
			const avantageTitle = createCustomElement('div');
			avantageTitle.classList.add('avantage-title');
			avantageTitle.innerHTML = avantage.nom;
			const avantageDesc = createCustomElement('div');
			avantageDesc.classList.add('avantage-desc');
			avantageDesc.innerHTML = avantage.desc;
			const avantageEntry = createCustomElement('div');
			avantageEntry.classList.add('avantage-entry');
			// action listener
			avantageTitle.onclick = () => {
				avantageEntry.classList.toggle('selected');
			}
			avantageEntry.appendChild(avantageTitle);
			avantageEntry.appendChild(avantageDesc);
			avantagesPane.appendChild(avantageEntry);
		}

		// -- désavantages
		const desavantagesPane = createCustomElement('div');
		desavantagesPane.classList.add('avantage-pane');
		if('desavantage' in this.character) {
			for (var desavantage of this.character.desavantage) {
				const desavantageTitle = createCustomElement('div');
				desavantageTitle.classList.add('avantage-title');
				desavantageTitle.innerHTML = desavantage.nom;
				const desavantageDesc = createCustomElement('div');
				desavantageDesc.classList.add('avantage-desc');
				desavantageDesc.innerHTML = desavantage.desc;
				const desavantageEntry = createCustomElement('div');
				desavantageEntry.classList.add('avantage-entry');
				// action listener
				desavantageTitle.onclick = () => {
					desavantageEntry.classList.toggle('selected');
				}
				desavantageEntry.appendChild(desavantageTitle);
				desavantageEntry.appendChild(desavantageDesc);
				desavantagesPane.appendChild(desavantageEntry);
			}
		}

		// -- pouvoirs
		const pouvoirsPane = createCustomElement('div');
		pouvoirsPane.classList.add('avantage-pane');
		for (var pouvoir of this.character.pouvoirs) {
			const pouvoirTitle = createCustomElement('div');
			pouvoirTitle.classList.add('avantage-title');
			pouvoirTitle.innerHTML = pouvoir.nom;
			const pouvoirDesc = createCustomElement('div');
			pouvoirDesc.classList.add('avantage-desc');
			pouvoirDesc.innerHTML = pouvoir.desc;
			const pouvoirEntry = createCustomElement('div');
			pouvoirEntry.classList.add('avantage-entry');
			// action listener
			pouvoirTitle.onclick = () => {
				pouvoirEntry.classList.toggle('selected');
			}
			pouvoirEntry.appendChild(pouvoirTitle);
			pouvoirEntry.appendChild(pouvoirDesc);
			pouvoirsPane.appendChild(pouvoirEntry);
		}

		// menu actions
		advDataMenuEquipement.onclick = () => {
			this.unselecteAdvData();
			advDataMenuEquipement.classList.add('selected');
			// avantagesPane.classList.add('selected');
		}
		advDataMenuAvantages.onclick = () => {
			this.unselecteAdvData();
			advDataMenuAvantages.classList.add('selected');
			avantagesPane.classList.add('selected');
		}
		advDataMenuDesavantages.onclick = () => {
			this.unselecteAdvData();
			advDataMenuDesavantages.classList.add('selected');
			desavantagesPane.classList.add('selected');
		}
		advDataMenuPouvoir.onclick = () => {
			this.unselecteAdvData();
			advDataMenuPouvoir.classList.add('selected');
			pouvoirsPane.classList.add('selected');
		}
		advDataMenuHistoire.onclick = () => {
			this.unselecteAdvData();
			advDataMenuHistoire.classList.add('selected');
			// histoirePane.classList.add('selected');
		}

		advDataMenuTop.appendChild(advDataMenuEquipement);
		advDataMenuTop.appendChild(advDataMenuAvantages);
		advDataMenuTop.appendChild(advDataMenuDesavantages);
		advDataMenuTop.appendChild(advDataMenuPouvoir);
		advDataMenuTop.appendChild(advDataMenuHistoire);
		advDataMenu.appendChild(advDataMenuTop);
		advDataMenuContainer.appendChild(avantagesPane);
		advDataMenuContainer.appendChild(desavantagesPane);
		advDataMenuContainer.appendChild(pouvoirsPane);
		advDataMenu.appendChild(advDataMenuContainer);
		this.advDataMenuItems = advDataMenuTop;
		this.advDataContainer = advDataMenuContainer;

		// dice roll (bonus / malus / normal)

		const rollDiceBtn = createCustomElement('div');
		rollDiceBtn.classList.add('btn-open-dice-roller');
		rollDiceBtn.onclick = () => {
			this.playSelectionSound();
			if(this.rollModel.attribute && this.rollModel.skill && this.rollModel.modif) {
				defineDiceRollAuth(this.character.nom);
				selectDiceAttributeModifier(this.rollModel.attribute.name, this.rollModel.attribute.value);
				selectDiceSkillModifier(this.rollModel.skill.name, this.rollModel.skill.value);
				selectDiceModifModifier(this.rollModel.modif.value, this.rollModel.modif.name);
				displayDiceRoller();
			} else {
				alert('Sélectionnez un \'Attribut\' et une \'Compétence\' (Carrière ou Combat)');
			}
		};

		row1.appendChild(r1c1);
		row1.appendChild(r1c2);
		row1.appendChild(r1c3);
		row1.appendChild(r1c4);
		container.appendChild(row1);
		row2.appendChild(r2c1);
		row2.appendChild(r2c2);
		row2.appendChild(r2c3);
		row2.appendChild(r2c4);
		row2.appendChild(r2c5);
		row2.appendChild(r2c6);
		row2.appendChild(r2c7);
		row2.appendChild(r2c8);
		container.appendChild(row2);
		advancedData.appendChild(advDataPoints);
		advancedData.appendChild(advDataMenu);
		container.appendChild(sheetExpander);
		container.appendChild(advancedData);
		container.appendChild(rollDiceBtn);
		document.body.appendChild(container);

		setAsDraggable(container, r1c1, () => {
			this.storeCurrentPosition();
		}, () => {
			this.loadStoredPosition();
		});

		this.ui = container;
		setTimeout(() => {
			this.storage.ui = { left: this.ui.style.left, top: this.ui.style.top };
			this.storage.minimizedUI = { left: this.ui.style.left, top: this.ui.style.top };
		});
	}

	unselecteAdvData() {
		for (var menuItem of this.advDataMenuItems.childNodes) {
			menuItem.classList.remove('selected');
		}
		for (var pane of this.advDataContainer.childNodes) {
			pane.classList.remove('selected');
		}
	}

	storeCurrentPosition() {
		if (this.ui.classList.contains('minimized')) {
			this.storage.minimizedUI = { left: this.ui.style.left, top: this.ui.style.top };
		} else {
			this.storage.ui = { left: this.ui.style.left, top: this.ui.style.top };
		}
	}

	loadStoredPosition() {
		if (this.ui.classList.contains('minimized')) {
			if(this.storage.minimizedUI) {
				this.ui.style.left = this.storage.minimizedUI.left;
				this.ui.style.top = this.storage.minimizedUI.top;
			}
		} else {
			if(this.storage.ui) {
				this.ui.style.left = this.storage.ui.left;
				this.ui.style.top = this.storage.ui.top;
			}
		}
	}

	toggleMinimized() {
		this.resetSelection();
		this.storeCurrentPosition();
		this.ui.classList.toggle('minimized');
		this.loadStoredPosition();
	}

	show() {
		this.ui.style.display = 'block';
	}

	hide() {
		this.ui.style.display = 'none';
	}

	isVisible() {
		return this.ui.style.display === 'none';
	}

	dispose() {
		// carrieres UI dispose
		for (var carrieresUI of this.carrieresUIList) {
			carrieresUI.dispose();
		}
		// attributes UI dispose
		this.vigueurUI.dispose();
		this.agiliteUI.dispose();
		this.espritUI.dispose();
		this.auraUI.dispose();
		// combat UI dispose
		this.initiativeUI.dispose();
		this.meleeUI.dispose();
		this.tirUI.dispose();
		this.defenseUI.dispose();
		// ref model clean
		this.carrieresUIList = [];
		this.rollModel = {}; // dice roll model
		this.uiSelectionModel = {}; // selection ui model
		// remove main UI from parrent
		if(this.ui.parentNode) {
			this.ui.parentNode.removeChild(this.ui);
		}
		sheetRegister.delete(this.key);
	}

	buildAttributUI(parent, title, value) {
		var selectable = new SelectableWidget(parent, title, value);
		selectable.ui.onclick = this.onAttributeUIClick(selectable);
		return selectable;
	}

	buildSkillUI(parent, title, value) {
		var selectable = new SelectableWidget(parent, title, value);
		selectable.ui.onclick = this.onSkillUIClick(selectable);
		return selectable;
	}

	buildDifficultyBtn(label, value) {
		var btnUI = createCustomElement('div');
		btnUI.classList.add('character-sheet-adv-column');
		var labelUI = createCustomElement('span');
		labelUI.innerHTML = label;
		labelUI.classList.add('character-sheet-adv-column-label');
		var valueUI = createCustomElement('div');
		valueUI.innerHTML = '' + ((value && value>=0) ? ('+'+value) : value);
		valueUI.classList.add('character-sheet-adv-column-value');
		btnUI.appendChild(labelUI);
		btnUI.appendChild(valueUI);

		btnUI.onclick = () => {
			const deselection = this.uiSelectionModel.modif;
			const selection = this.uiSelectionModel.modif != btnUI;
			if (deselection) {
				// deselection
				this.uiSelectionModel.modif.classList.remove('selected');
				this.rollModel.modif = null;
				this.uiSelectionModel.modif = null;
			}
			if (selection) {
				// select current
				this.rollModel.modif = { name: label, value: value };
				this.uiSelectionModel.modif = btnUI;
				this.uiSelectionModel.modif.classList.add('selected');
			}
			this.updateUIState();
		};

		return btnUI;
	}

	resetSelection() {
		// ui deselection
		if(this.uiSelectionModel.attribute) {
			this.uiSelectionModel.attribute.unselect();
			this.uiSelectionModel.attribute = null;
		}
		if(this.uiSelectionModel.skill) {
			this.uiSelectionModel.skill.unselect();
			this.uiSelectionModel.skill = null;
		}
		if(this.uiSelectionModel.modif) {
			this.uiSelectionModel.modif.classList.remove('selected');
			this.uiSelectionModel.modif = null;
		}
		// roll deselection
		this.rollModel.attribute = null;
		this.rollModel.skill = null;
		this.rollModel.modif = null;

		this.updateUIState();
	}

	playSelectionSound() {
		const sound = new Audio('http://sda-campagne.fr/misc/greek_theme/sound/select.wav');
		sound.volume = 0.1;
		sound.play();
	}

	updateUIState() {
		if(this.rollModel.attribute && this.rollModel.skill) {
			if(this.rollModel.modif) {
				this.ui.classList.add('modif-ready');
				this.ui.classList.add('roll-ready');
			} else {
				this.ui.classList.add('modif-ready');
				this.ui.classList.remove('roll-ready');
			}
		} else {
			this.ui.classList.remove('modif-ready');
			this.ui.classList.remove('roll-ready');
		}
	}

	onAttributeUIClick(attributeUI) {
		return () => {
			this.playSelectionSound();
			console.log('onAttributeUIClick');
			console.log('onAttributeUIClick');
			const deselection = this.uiSelectionModel.attribute;
			const selection = this.uiSelectionModel.attribute != attributeUI;
			if (deselection) {
				// ui deselection
				this.uiSelectionModel.attribute.unselect();
				this.uiSelectionModel.attribute = null;
				// roll deselection
				this.rollModel.attribute = null;
			}
			if (selection) {
				// ui selection
				this.uiSelectionModel.attribute = attributeUI;
				this.uiSelectionModel.attribute.select();

				// roll selection
				this.rollModel.attribute = JSON.parse(JSON.stringify(attributeUI.model)); // clone
			}
			this.updateUIState();
		};
	}

	onSkillUIClick(skillUI) {
		return () => {
			this.playSelectionSound();
			const deselection = this.uiSelectionModel.skill;
			const selection = this.uiSelectionModel.skill != skillUI;
			if (deselection) {
				// ui deselection
				this.uiSelectionModel.skill.unselect();
				this.uiSelectionModel.skill = null;
				// roll deselection
				this.rollModel.skill = null;
			}
			if (selection) {
				// ui selection
				this.uiSelectionModel.skill = skillUI;
				this.uiSelectionModel.skill.select();

				// roll selection
				this.rollModel.skill = JSON.parse(JSON.stringify(skillUI.model)); // clone
			}
			this.updateUIState();
		};
	}

	updateUI() {
		this.resetSelection();

		// nom + image
		this.nameUI.innerHTML = this.character.nom;
		if (this.character.image) {
			this.imageUI.style.backgroundImage = 'url(\'' + this.character.image + '\')';
		} else {
			this.imageUI.style.backgroundImage = 'none';
		}

		// carrieres
		for (var carrieresUI of this.carrieresUIList) {
			carrieresUI.dispose();
		}
		this.carrieresUIList = [];
		for (var carriere of this.character.carrieres) {
			this.carrieresUIList.push(this.buildSkillUI(this.carrieresUI, carriere.nom , carriere.score));
		}

		// models reset
		this.rollModel = {}; // dice roll model
		this.uiSelectionModel = {}; // selection ui model

		this.vigueurUI.update(this.character.attributs.vigueur);
		this.agiliteUI.update(this.character.attributs.agilite);
		this.espritUI.update(this.character.attributs.esprit);
		this.auraUI.update(this.character.attributs.aura);
		// combat
		this.initiativeUI.update(this.character.combat.initiative);
		this.meleeUI.update(this.character.combat.melee);
		this.tirUI.update(this.character.combat.tir);
		this.defenseUI.update(this.character.combat.defense);
	}
}


function setCurrentPJ(pj) {
	var sheet = sheetRegister.get(pj.nom)
	if (!sheetRegister.get(pj.nom)) {
		sheet = new characterSheet();
		sheet.setCharacter(pj);
	}
}

function displayCharSheets() {
	var diceRoller = document.getElementById('bol-dice-roller');
	diceRoller.style.display = 'none';
	for (var sheet of sheetRegister.values()) {
		sheet.show();
	}
}
function displayDiceRoller() {
	resetDices(true);
	var diceRoller = document.getElementById('bol-dice-roller');
	diceRoller.style.display = 'block';
	for (var sheet of sheetRegister.values()) {
		sheet.hide();
	}
}
function toogleCharSheets() {
	var diceRoller = document.getElementById('bol-dice-roller');
	diceRoller.style.display = 'none';
	for (var sheet of sheetRegister.values()) {
		if(sheet.isVisible()) {
			sheet.show();
		} else {
			sheet.hide();
		}
	}
}