var nb_gme = 0;
function createCustomElement(type) {
	const e = document.createElement(type);
	e.className = 'gme';
	nb_gme++;
	const GME_Elements = document.querySelectorAll('.gme').length;
	console.log('nb elt. = ' + nb_gme + '; prev. total = ' + GME_Elements);
	return e;
}

// waiting an element creation in the DOM
function waitElementExist(id, callback, time) {
	if(document.getElementById(id)) {
		console.log('THEME: "'+id+'" ok');
		callback();
	} else {
		console.log('THEME: waiting "'+id+'" ...');
		setTimeout(() => { waitElementExist(id, callback); }, time ? time : 500);
	}
}

// ------------------------------------------------- //
// ----------------- Drag and drop ----------------- //
// ------------------------------------------------- //

var droppableElt = null;
var dropDestElt = null;
var droppingAction = null;
var dropOutManager = null;

function setAsDraggable(elmnt, handler, onDragStart, onDropOut) {

	// to manage the drop cancel
	var beforeMoveX = 0, beforeMoveY = 0;

	// to manage the dynamic drag move
	var offsetX = 0, offsetY = 0, oldX = 0, oldY = 0, originX = 0, originY = 0;

	if (handler) {
		/* if present, the header is where you move the DIV from:*/
		handler.onmousedown = dragMouseDown;
	} else {
		/* otherwise, move the DIV from anywhere inside the DIV:*/
		elmnt.onmousedown = dragMouseDown;
	}

	function dragMouseDown(e) {
		e = e || window.event;
		e.preventDefault();
		if(onDragStart) {
			onDragStart();
		}

		// get the mouse cursor position at startup:
		originX = elmnt.offsetLeft;
		originY = elmnt.offsetTop;
		oldX = e.clientX;
		oldY = e.clientY;
		console.log('!!! originX='+originX+ ' ; originY='+originY+ ' ; oldX='+oldX+ ' ; oldY='+oldY);
		document.onmouseup = closeDragElement;
		// call a function whenever the cursor moves:
		document.onmousemove = elementDrag;
		//to manage drop
		document.body.classList.add('dragging');
		droppableElt = elmnt;
		dropDestElt = null;
		console.log('drag:: ' + droppableElt.id);
	}

	function elementDrag(e) {
		e = e || window.event;
		e.preventDefault();
		// calculate the new cursor position:
		offsetX = e.clientX - oldX;
		offsetY = e.clientY - oldY;
		originX = originX + offsetX;
		originY = originY + offsetY;
		oldX = e.clientX;
		oldY = e.clientY;
		// set the element's new position:
		elmnt.style.left = originX + "px";
		elmnt.style.top = originY + "px";

	}

	function closeDragElement() {
		/* stop moving when mouse button is released:*/
		document.onmouseup = null;
		document.onmousemove = null;
		document.body.classList.remove('dragging');
		if (dropDestElt) {
			// perform drop
			console.log('dropping...');
			if (droppingAction) {
				console.log('dropping action...');
				console.log('drop:: ' + droppableElt.id);
				droppingAction(droppableElt, onDropOut);
			}
		} else {
			console.log('no drop');
		}
		droppableElt = null;
		droppingAction = null;
	}
}

function setAsDropContainer(container, droppingFct) {
	container.onmouseover = () => {
		if(droppableElt) {
			droppingAction = droppingFct;
			dropDestElt = container;
		}
	};
	container.onmouseout = () => {
		if(droppableElt && dropDestElt===container) {
			droppingAction = null;
			dropDestElt = null;
		}
	};
}