//---------------------------------------
//------------ dice 6 roller ------------
//---------------------------------------

var bolDiceRoller = createCustomElement('div');
bolDiceRoller.id = 'bol-dice-roller';
document.body.appendChild(bolDiceRoller);


// -- build dice disk
//-------------------
var diceRollerDisk = createCustomElement('div');
diceRollerDisk.id = 'dice-roller-disk';
bolDiceRoller.appendChild(diceRollerDisk);

var diceRollerBackDisk = createCustomElement('div');
diceRollerBackDisk.id = 'dice-roller-back-disk';
bolDiceRoller.appendChild(diceRollerBackDisk);


// -- build circle menu:
//----------------------

var diceRollAuth;
function defineDiceRollAuth(charName) {
	diceRollAuth = charName;
}

// ---- menu item Attribute :
var menuSelectorAttribute = createCustomElement('div');
menuSelectorAttribute.id = 'dice-menu-selector-attribute';
menuSelectorAttribute.classList.add('dice-menu-selector-item');
menuSelectorAttribute.onclick = displayCharSheets;
diceRollerBackDisk.appendChild(menuSelectorAttribute);
var menuSelectorAttributeLabel = createCustomElement('div');
menuSelectorAttributeLabel.id = 'dice-menu-selector-attribute-label';
menuSelectorAttributeLabel.classList.add('dice-menu-selector-item-label');
menuSelectorAttributeLabel.innerHTML = 'Attribut';
diceRollerBackDisk.appendChild(menuSelectorAttributeLabel);
var menuSelectorAttributeValue = createCustomElement('div');
menuSelectorAttributeValue.id = 'dice-menu-selector-attribute-value';
menuSelectorAttributeValue.classList.add('dice-menu-selector-item-value');
bolDiceRoller.appendChild(menuSelectorAttributeValue);
var attributeDiceValue;
var attributeDiceName;
function selectDiceAttributeModifier(name, value) {
	if (name) {
		attributeDiceName = name;
	} else {
		attributeDiceName = 'Attribut';
	}
	menuSelectorAttributeLabel.innerHTML = attributeDiceName;
	attributeDiceValue = value;
	menuSelectorAttributeValue.innerHTML = attributeDiceValue >= 0 ? ('+' + attributeDiceValue) : attributeDiceValue;
}
selectDiceAttributeModifier(0);
// ---- menu item Skill :
var menuSelectorSkill = createCustomElement('div');
menuSelectorSkill.id = 'dice-menu-selector-skill';
menuSelectorSkill.classList.add('dice-menu-selector-item');
menuSelectorSkill.onclick = displayCharSheets;
diceRollerBackDisk.appendChild(menuSelectorSkill);
var menuSelectorSkillLabel = createCustomElement('div');
menuSelectorSkillLabel.id = 'dice-menu-selector-skill-label';
menuSelectorSkillLabel.classList.add('dice-menu-selector-item-label');
menuSelectorSkillLabel.innerHTML = 'Compétence';
diceRollerBackDisk.appendChild(menuSelectorSkillLabel);
var menuSelectorSkillValue = createCustomElement('div');
menuSelectorSkillValue.id = 'dice-menu-selector-skill-value';
menuSelectorSkillValue.classList.add('dice-menu-selector-item-value');
bolDiceRoller.appendChild(menuSelectorSkillValue);
var skillDiceValue;
var skillDiceName;
function selectDiceSkillModifier(name, value) {
	if (name) {
		skillDiceName = name;
	} else {
		skillDiceName = 'Compétence';
	}
	menuSelectorSkillLabel.innerHTML = skillDiceName;
	skillDiceValue = value;
	menuSelectorSkillValue.innerHTML = skillDiceValue >= 0 ? ('+' + skillDiceValue) : skillDiceValue;
}
selectDiceSkillModifier(0);
// ---- menu item Modifier (difficulty / custom) :
var menuSelectorModif = createCustomElement('div');
menuSelectorModif.id = 'dice-menu-selector-modif';
menuSelectorModif.classList.add('dice-menu-selector-item');
menuSelectorModif.onclick = toggleModifChooser;
diceRollerBackDisk.appendChild(menuSelectorModif);
var menuSelectorModifLabel = createCustomElement('div');
menuSelectorModifLabel.id = 'dice-menu-selector-modif-label';
menuSelectorModifLabel.classList.add('dice-menu-selector-item-label');
menuSelectorModifLabel.innerHTML = 'Difficulté';
diceRollerBackDisk.appendChild(menuSelectorModifLabel);
var menuSelectorModifValue = createCustomElement('div');
menuSelectorModifValue.id = 'dice-menu-selector-modif-value';
menuSelectorModifValue.classList.add('dice-menu-selector-item-value');
bolDiceRoller.appendChild(menuSelectorModifValue);
var modifDiceValue;
var modifDiceName;
function selectDiceModifModifier(value, label) {
	modifDiceValue = value;
	if(label) {
		modifDiceName = label + ' ('+ (value>=0 ? ('+'+value) : value) + ')';
	} else {
		modifDiceName = 'Difficulté ' + (value>=0 ? ('+'+value) : value);
	}
	menuSelectorModifValue.innerHTML = modifDiceValue >= 0 ? ('+' + modifDiceValue) : modifDiceValue;
	menuSelectorModifLabel.innerHTML = label ? ('Difficulté : ' + label) : 'Difficulté';
}
selectDiceModifModifier(0);

// ----------- Bonus / Malus :
var btnDiceBonus = createCustomElement('div');
btnDiceBonus.id = 'btn-dice-bonus';
btnDiceBonus.onclick = addDiceBonus;
diceRollerBackDisk.appendChild(btnDiceBonus);

var btnDiceMalus = createCustomElement('div');
btnDiceMalus.id = 'btn-dice-malus';
btnDiceMalus.onclick = addDiceMalus;
diceRollerBackDisk.appendChild(btnDiceMalus);

var diceRollLevel = 0;
function resetDices(removeDices) {
	while (diceRoller.firstChild) {
		diceRoller.removeChild(diceRoller.firstChild);
	}
	diceRoller.appendChild(createDiceElement());
	diceRoller.appendChild(createDiceElement());
	if (removeDices) {
		diceRollLevel = 0;
	} else {
		var n = Math.abs(diceRollLevel);
		while(n > 0) {
			diceRoller.appendChild(createDiceElement());
			n--;
		}
	}
	diceRollerDisk.classList.remove('bonus');
	diceRollerDisk.classList.remove('malus');
	btnDiceMalus.classList.remove('reset');
	btnDiceBonus.classList.remove('reset');
	bolDiceRoller.classList.remove('rolled');
	bolDiceRoller.classList.remove('success');
	bolDiceRoller.classList.remove('fail');
	bolDiceRoller.classList.remove('heroic-success');
	bolDiceRoller.classList.remove('fumble');
}
function addDiceBonus() {
	if (diceRollLevel >= 0) {
		resetDices(false);
		if( diceRollLevel >= 4) {
			return; // max nb of bonus dice
		}
		diceRollLevel++;
		diceRoller.appendChild(createDiceElement());
		diceRollerDisk.classList.add('bonus');
		btnDiceMalus.classList.add('reset');
	} else {
		resetDices(true);
	}
}
function addDiceMalus() {
	if (diceRollLevel <= 0) {
		resetDices(false);
		if( diceRollLevel <= -4) {
			return; // max nb of malus dice
		}
		diceRollLevel--;
		diceRoller.appendChild(createDiceElement());
		diceRollerDisk.classList.add('malus');
		btnDiceBonus.classList.add('reset');
	} else {
		resetDices(true);
	}
}

// --------- Dice roll result :
var diceRollerResult = createCustomElement('div');
diceRollerResult.id = 'dice-roller-result';
bolDiceRoller.appendChild(diceRollerResult);


// -- build modificateur chooser (difficulty or custom):
//------------------------------------------------------

var diceRollerModifChooser = createCustomElement('div');
diceRollerModifChooser.id = 'dice-roller-chooser';
bolDiceRoller.appendChild(diceRollerModifChooser);
function toggleModifChooser() {
	if (diceRollerModifChooser.style.opacity === '1') {
		hideModifChooser();
	} else {
		showModifChooser();
	}
}
function showModifChooser() {
	diceRollerModifChooser.style.display = 'block';
	setTimeout(() => {
	diceRollerModifChooser.style.opacity = '1';
	}, 100);
	menuSelectorModif.classList.add('active');
}
function hideModifChooser() {
	diceRollerModifChooser.style.opacity = '0';
	setTimeout(() => {
		diceRollerModifChooser.style.display = 'none';
	}, 600);
	menuSelectorModif.classList.remove('active');
}
//-- dice modif Tres facile
var diceModif_TresFacile = createCustomElement('div');
diceModif_TresFacile.classList.add('dice-modif');
diceModif_TresFacile.innerHTML = '<div>Très Facile</div><div>+2</div>';
diceModif_TresFacile.onclick = () => {
	selectDiceModifModifier(2, 'Très Facile');
	hideModifChooser();
}
diceRollerModifChooser.appendChild(diceModif_TresFacile);
//-- dice modif Facile
var diceModif_Facile = createCustomElement('div');
diceModif_Facile.classList.add('dice-modif');
diceModif_Facile.innerHTML = '<div>Facile</div><div>+1</div>';
diceModif_Facile.onclick = () => {
	selectDiceModifModifier(1, 'Facile');
	hideModifChooser();
}
diceRollerModifChooser.appendChild(diceModif_Facile);
//-- dice modif Moyen
var diceModif_Moyen = createCustomElement('div');
diceModif_Moyen.classList.add('dice-modif');
diceModif_Moyen.innerHTML = '<div>Moyen</div><div>0</div>';
diceModif_Moyen.onclick = () => {
	selectDiceModifModifier(0, 'Moyen');
	hideModifChooser();
}
diceRollerModifChooser.appendChild(diceModif_Moyen);
//-- dice modif Ardue
var diceModif_Ardue = createCustomElement('div');
diceModif_Ardue.classList.add('dice-modif');
diceModif_Ardue.innerHTML = '<div>Ardue</div><div>-1</div>';
diceModif_Ardue.onclick = () => {
	selectDiceModifModifier(-1, 'Ardue');
	hideModifChooser();
}
diceRollerModifChooser.appendChild(diceModif_Ardue);
//-- dice modif Difficile
var diceModif_Difficile = createCustomElement('div');
diceModif_Difficile.classList.add('dice-modif');
diceModif_Difficile.innerHTML = '<div>Difficile</div><div>-2</div>';
diceModif_Difficile.onclick = () => {
	selectDiceModifModifier(-2, 'Difficile');
	hideModifChooser();
}
diceRollerModifChooser.appendChild(diceModif_Difficile);
//-- dice modif Très Difficile
var diceModif_TresDifficile = createCustomElement('div');
diceModif_TresDifficile.classList.add('dice-modif');
diceModif_TresDifficile.innerHTML = '<div>Très Difficile</div><div>-4</div>';
diceModif_TresDifficile.onclick = () => {
	selectDiceModifModifier(-4, 'Très Difficile');
	hideModifChooser();
}
diceRollerModifChooser.appendChild(diceModif_TresDifficile);
//-- dice modif Impossible
var diceModif_Impossible = createCustomElement('div');
diceModif_Impossible.classList.add('dice-modif');
diceModif_Impossible.innerHTML = '<div>Impossible</div><div>-6</div>';
diceModif_Impossible.onclick = () => {
	selectDiceModifModifier(-6, 'Impossible');
	hideModifChooser();
}
diceRollerModifChooser.appendChild(diceModif_Impossible);
//-- dice modif Heroïque
var diceModif_Heroique = createCustomElement('div');
diceModif_Heroique.classList.add('dice-modif');
diceModif_Heroique.innerHTML = '<div>Heroïque</div><div>-8</div>';
diceModif_Heroique.onclick = () => {
	selectDiceModifModifier(-8, 'Heroïque');
	hideModifChooser();
}
diceRollerModifChooser.appendChild(diceModif_Heroique);
//-- dice modif custom
var diceModifCustonValue = 0;
var diceModif_Custom = createCustomElement('button');
diceModif_Custom.classList.add('dice-modif-mano');
diceModif_Custom.classList.add('dice-modif');
diceModif_Custom.innerHTML = 'Autre';
diceModif_Custom.onclick = () => {
	selectDiceModifModifier(diceModifCustonValue);
	hideModifChooser();
}
diceRollerModifChooser.appendChild(diceModif_Custom);
//-- dice modif custom button '+'
var diceModif_CustomPlus = createCustomElement('button');
diceModif_CustomPlus.id = 'dice-modif-plus';
diceModif_CustomPlus.classList.add('dice-modif-btn');
diceModif_CustomPlus.innerHTML = '+';
diceModif_CustomPlus.onclick = () => {
	diceModifCustonValue++;
	diceModif_Custom.innerHTML = diceModifCustonValue >= 0 ? ('+' + diceModifCustonValue) : diceModifCustonValue;
}
diceRollerModifChooser.appendChild(diceModif_CustomPlus);
//-- dice modif custom button '-'
var diceModif_CustomMinus = createCustomElement('button');
diceModif_CustomMinus.id = 'dice-modif-minus';
diceModif_CustomMinus.classList.add('dice-modif-btn');
diceModif_CustomMinus.innerHTML = '-';
diceModif_CustomMinus.onclick = () => {
	diceModifCustonValue--;
	diceModif_Custom.innerHTML = diceModifCustonValue >= 0 ? ('+' + diceModifCustonValue) : diceModifCustonValue;
}
diceRollerModifChooser.appendChild(diceModif_CustomMinus);


// setAsDraggable(diceRollerDisk);



class diceRollerUI {

	constructor(parent, name, value) {
		this.model = { name: name, value: value };
		this.buildUI(parent);
	}

	buildUI() {

	}
}

// -- build roller (dice container):
//----------------------------------

var diceRoller = createCustomElement('div');
diceRoller.classList.add('dice6-roller');
diceRollerDisk.appendChild(diceRoller);

diceRoller.appendChild(createDiceElement());
diceRoller.appendChild(createDiceElement());

function createDiceElement() {

	var dice = createCustomElement('section');
	dice.classList.add('dice');

	var cube = createCustomElement('div');
	cube.classList.add('dice-cube');
	dice.appendChild(cube);

	var front = createCustomElement('div');
	front.classList.add('dice-front');
	front.innerHTML = '<span class="dot dot1"></span>'
	cube.appendChild(front);

	var bottom = createCustomElement('div');
	bottom.classList.add('dice-bottom');
	bottom.innerHTML = '<span class="dot dot1"></span><span class="dot dot2"></span>';
	cube.appendChild(bottom);

	var right = createCustomElement('div');
	right.classList.add('dice-right');
	right.innerHTML = '<span class="dot dot1"></span><span class="dot dot2"></span><span class="dot dot3"></span>';
	cube.appendChild(right);

	var left = createCustomElement('div');
	left.classList.add('dice-left');
	left.innerHTML = '<span class="dot dot1"></span><span class="dot dot2"></span><span class="dot dot3"></span><span class="dot dot4"></span>';
	cube.appendChild(left);

	var top = createCustomElement('div');
	top.classList.add('dice-top');
	top.innerHTML = '<span class="dot dot1"></span><span class="dot dot2"></span><span class="dot dot3"></span><span class="dot dot4"></span><span class="dot dot5"></span>';
	cube.appendChild(top);

	var back = createCustomElement('div');
	back.classList.add('dice-back');
	back.innerHTML = '<span class="dot dot1"></span><span class="dot dot2"></span><span class="dot dot3"></span><span class="dot dot4"></span><span class="dot dot5"></span><span class="dot dot6"></span>';
	cube.appendChild(back);

	return dice;
}

var reset = false;
diceRollerDisk.ondblclick = function() {

	var resValues = [];
	var resDices = [];
	var cubes = document.getElementsByClassName('dice-cube');

	var min = 4;
	var max = 12;

	if(!reset) {
		setTimeout(() => {
			var d1, d2;
			var d1Idx, d2Idx;
			var d1Elt, d2Elt;
			if (diceRollLevel >= 0) {
				d1 = 0;
				d2 =0;
			} else {
				d1 = 6;
				d2 = 6;
			}
			var diceSelection = [];
			for(var idx in resValues) {
				diceSelection.push(false);
				const value = resValues[idx];
				const elt = resDices[idx];
				console.log('check value : ' + value);
				// store dice value
				if (diceRollLevel > 0) {
					if (value > d1 || value > d2) {
						if (d1 > d2) {
							console.log('replace D1 '+d2+' by ' + value);
							d2 = value;
							d2Elt = elt;
							d2Idx = idx;
						} else {
							console.log('replace D1 '+d1+' by ' + value);
							d1 = value;
							d1Elt = elt;
							d1Idx = idx;
						}
					}
				} else if (diceRollLevel < 0) {
					if (value < d1 || value < d2) {
						if (d1 < d2) {
							console.log('replace D1 '+d2+' by ' + value);
							d2 = value;
							d2Elt = elt;
							d2Idx = idx;
						} else {
							console.log('replace D1 '+d1+' by ' + value);
							d1 = value;
							d1Elt = elt;
							d1Idx = idx;
						}
					}
				} else {
					if(d1 == 0) {
						d1 = value;
						d1Elt = elt;
						d1Idx = idx;
					} else {
						d2 = value;
						d2Elt = elt;
						d2Idx = idx;
					}
				}
			}
			diceSelection[d1Idx] = true;
			diceSelection[d2Idx] = true;
			if (diceRollLevel > 0) {
				d1Elt.classList.add('dice-max');
				d2Elt.classList.add('dice-max');
			} else if (diceRollLevel < 0) {
				d1Elt.classList.add('dice-min');
				d2Elt.classList.add('dice-min');
			}
			console.log('Resultat D1: ' + d1);
			console.log('Resultat D2 : ' + d2);
			bolDiceRoller.classList.add('rolled');
			var result = d1+d2;
			var type = null;
			var modif = modifDiceValue + attributeDiceValue + skillDiceValue;
			if(result == 12) {
				// heroic success
				bolDiceRoller.classList.add('heroic-success');
				diceRollerResult.innerHTML = result;
				type = 'heroic';
			} else if(result == 2) {
				// fumble
				bolDiceRoller.classList.add('fumble');
				diceRollerResult.innerHTML = '';
				type = 'fumble';
			} else {
				// normal result
				result += modif;
				bolDiceRoller.classList.add(result > 8 ? 'success' : 'fail');
				type = result > 8 ? 'success' : 'fail';
				diceRollerResult.innerHTML = result;
			}
			var rollResult = {
				auth: diceRollAuth,
				attribute: {
					name: attributeDiceName,
					value: attributeDiceValue
				},
				skill: {
					name: skillDiceName,
					value: skillDiceValue
				},
				modif: modif,
				diff: modifDiceName,
				dices: resValues,
				diceSelection: diceSelection,
				result: result,
				type: type,
				diceRollLevel: diceRollLevel
			};
			sendBolDiceResult(rollResult);
		}, 3000);
	} else {
		resetDices(true);
	}
	Array.from(cubes).forEach((cube) => {
		if(!reset) {
			var xRand = getRandom(max, min);
			var yRand = getRandom(max, min);
			var zRand = getRandom(0, 3);

			var rollZXY = [
				[ /*Z:0*/
					[1, 4, 6, 3], /*X:0*/
					[2, 4, 5, 3], /*X:1*/
					[6, 4, 1, 3], /*X:2*/
					[5, 4, 2, 3] /*X:3*/
				],
				[ /*Z:1*/
					[1, 2, 6, 5],
					[2, 6, 5, 1],
					[6, 5, 1, 2],
					[5, 1, 2, 6]
				],
				[ /*Z:2*/
					[1, 3, 6, 4],
					[2, 3, 5, 4],
					[6, 3, 1, 4],
					[5, 3, 2, 4]
				]
			];

			//console.log('zRand:'+zRand + ' ; xRand:'+xRand+ ' ; yRand:' +yRand);
			var x = (xRand / 90) % 4;
			var y = (yRand / 90) % 4;
			var z = (zRand / 90) % 4;
			console.log('z:' + z + ' ; x:' + x + ' ; y:' + y);
			console.log('EXPECTED : ' + rollZXY[z][x][y]);
			cube.style.transition = 'transform 3s';
			roll(cube, xRand, yRand, zRand);

			resValues.push(rollZXY[z][x][y]);
			resDices.push(cube);
		}
	});
	reset = !reset;
};

function roll(cube, x, y, z) {
	var transX = 'rotateX(' + x + 'deg) ';
	var transY = 'rotateY(' + y + 'deg) ';
	var transZ = 'rotateZ(' + z + 'deg) ';
	cube.style.transform = transY + transZ + transX;
	cube.style.webkitTransform = cube.style.transform;
}

function getRandom(max, min) {
	return (Math.floor(Math.random() * (max-min)) + min) * 90;
}

function sendBolDiceResult(rollResult) {
	var msg = '[dice-roll-bol]:' + JSON.stringify(rollResult);
	chatTextArea.value = msg;
	chatBtn.click();
}
