

//------------------------------------------------------------//
//---------- Send data via Chat (image & sound) --------------//
//------------------------------------------------------------//
var inputDiv = document.getElementById('textchat-input');
var chatTextArea = inputDiv.children[1];
var chatBtn = inputDiv.lastElementChild;
function sendDataByChat(url, mode) {
	if(url) {
		console.log('mode: ' + mode);
		switch(mode) {
			case 'circle':
				chatTextArea.value = 'img-circle=' + url;
				break;
			case 'wide':
				chatTextArea.value = 'img-wide=' + url;
				break;
			default:
				// file type:
				if(url.indexOf('.mp3') >= 0
				   || url.indexOf('.wav') >= 0
				   || url.indexOf('.ogg') >= 0) {
					chatTextArea.value = 'sound=' + url;
				} else if(url.indexOf('.jpg') >= 0
						  || url.indexOf('.jpeg') >= 0
						  || url.indexOf('.png') >= 0
						  || url.indexOf('.bmp') >= 0) {
					chatTextArea.value = 'img=' + url;
				} else if(url.indexOf('www.youtube.com') >= 0) {
					chatTextArea.value = 'yt=' + url;
				}
				break;
		}
		chatBtn.click();
	}
};


var sentFileImg = createCustomElement('img');
sentFileImg.src = 'http://sda-campagne.fr/misc/file_attchment.png';
var sentFileBtn = createCustomElement('div');
sentFileBtn.id = 'sentFileBtn';
sentFileBtn.style.display = 'inline-block';
sentFileBtn.style.paddingRight = '10px';
sentFileBtn.style.paddingLeft = '5px';
sentFileBtn.style.cursor = 'pointer';
sentFileBtn.onclick = function() {
	var url = prompt("URL du fichier :", "");
	sendDataByChat(url);
};
if (!document.getElementById('sentFileBtn')) {
	sentFileBtn.appendChild(sentFileImg);
	inputDiv.insertBefore(sentFileBtn, inputDiv.lastElementChild);
}




const intervalCtxtMenuTool = 1000;
const addCtxtMenuTool = () => {
	if(!isChatInit) {
		setTimeout(addCtxtMenuTool, intervalCtxtMenuTool);
		return;
	}
	// add action into context menu
	var selection;
	var findTargetImgLib = (event) => {
		var target = event.target;
		while (target && target.tagName != 'OL') {
			if (target.id && target.id == 'libraryfolderroot') {
				break;
			}
			if (target.tagName == 'LI') {
				selection = target;
				return;
			}
			target = target.parentNode;
		}
	}
	document.getElementById('libraryfolderroot').addEventListener("contextmenu", findTargetImgLib);
	document.getElementById('recentuploads').addEventListener("contextmenu", findTargetImgLib);

	var sendImgItemMenu = createCustomElement('li');
	sendImgItemMenu.innerHTML = 'Afficher pour tous';

	var ctxtMenu1 = document.getElementById('libraryitemmenu');
	sendImgItemMenu.addEventListener("mousedown", () => {
		ctxtMenu1.style.display = 'none';
		var src = selection.getAttribute('data-fullsizeurl');
		chatTextArea.value = 'img=' + src;
		chatBtn.click();
	}, false);
	ctxtMenu1.children[0].appendChild(sendImgItemMenu);

	var ctxtMenu2 = document.getElementById('librarycopymenu');
	sendImgItemMenu = sendImgItemMenu.cloneNode(true);
	sendImgItemMenu.addEventListener("mousedown", () => {
		ctxtMenu2.style.display = 'none';
		var src = selection.getAttribute('data-fullsizeurl');
		chatTextArea.value = 'img=' + src;
		chatBtn.click();
	}, false);
	ctxtMenu2.children[0].appendChild(sendImgItemMenu);

	// add observer on chat content
}
setTimeout(addCtxtMenuTool, intervalCtxtMenuTool);