//------------------------------------------//
//-------------- Menu D&D ------------------//
//------------------------------------------//
var menu = createCustomElement('div');
menu.id = 'menu-custom';
var menu_button = createCustomElement('div');
menu_button.id = 'menu-custom-button';
menu_button.classList.add('ripple');
menu_button.onclick = function() {
	/*
	var wrapper = document.getElementById('editor-wrapper');
	if(menu.classList.contains("activated")) {
		menu.classList.remove("activated");
		wrapper.classList.remove('undisplayed');
	} else {
		menu.classList.add("activated");
		wrapper.classList.add('undisplayed');
	}
	*/
	toogleCharSheets();
};
var menu_content = createCustomElement('div');
menu_content.id = 'menu-custom-content';

var linkRules = createCustomElement('a');
linkRules.id = 'link-rules';
linkRules.title="Regles"
linkRules.href="https://www.aidedd.org/regles"
linkRules.target="_blank";
linkRules.innerHTML = '<span class="pictos">s</span>';

var notes = createCustomElement('textarea');
notes.id = 'myNotes';
notes.setAttribute("spellcheck", "false");

var isGM = false;
var gameData = null;
const manageNotesStorage = () => {
	if(!isChatInit) {
		setTimeout(manageNotesStorage, 3000);
		return;
	}

	// search campaign ID from roll20 local storage
	var storageKeys = Object.keys(localStorage);
	var campaignID = 'all';
	for(var key of storageKeys) {
		var data = localStorage.getItem(key);
		if (!data.startsWith('{')) {
			continue;
		}
		data = JSON.parse(data);
		if(data
		   && data.hasOwnProperty('auth')
		   && data.auth.hasOwnProperty('playerid')
		   && data.auth.hasOwnProperty('currentcampaign')) {
			var playerDiv = document.getElementById('player_' + data.auth.playerid);
			if(playerDiv) {
				campaignID = data.auth.currentcampaign;
				isGM = data.auth.is_gm;
				onUserStatusKnown();
				break;
			}
		}
	}
	// retrieve stored notes if exists
	var storageKey = 'myNotes[' + campaignID + ']';
	var storedNotes = localStorage.getItem(storageKey);
	if(storedNotes) {
		notes.value = storedNotes;
	}

	// text area notes storage
	if(notes.addEventListener) {
		notes.addEventListener('input', function() {
			localStorage.setItem(storageKey, notes.value);
		}, false);
	} else if (notes.attachEvent) {
		notes.attachEvent('onpropertychange', function() {
			localStorage.setItem(storageKey, notes.value);
		});
	}
}
setTimeout(manageNotesStorage, 3000);

menu.style.display = 'none';

document.body.appendChild(menu);
menu.appendChild(menu_button);
menu.appendChild(menu_content);
//    menu_content.appendChild(linkRules);
menu_content.appendChild(notes);


//------------------------------------------//
//--------- Splash Screen Strahd -----------//
//------------------------------------------//
var splashScreen = createCustomElement('div');
splashScreen.id = 'splashScreen';
splashScreen.style.display = 'block';
splashScreen.style.position = 'absolute';
splashScreen.style.top = '-100vh';
splashScreen.style.left = '0';
splashScreen.style.width = '100%';
splashScreen.style.height = '100%';
splashScreen.style.zIndex = '999999';
splashScreen.style.backgroundImage = 'url("https://i.pinimg.com/originals/ae/52/85/ae52850e2f246ce98220bb222ae97dfc.jpg")';
splashScreen.style.backgroundSize = 'contain';
splashScreen.style.backgroundRepeat = 'no-repeat';
splashScreen.style.backgroundPosition = 'center center';
splashScreen.style.backgroundColor = '#18191b';
splashScreen.style.opacity = '0';

splashScreen.style.transition = 'opacity 3.5s ease-in-out';
splashScreen.style.WebkitTransition = 'opacity 3.5s ease-in-out';
splashScreen.style.MozTransition = 'opacity 3.5s ease-in-out';
splashScreen.style.setProperty('-webkit-transition', 'opacity 3.5s ease-in-out');
splashScreen.style.setProperty('transition', 'opacity 3.5s ease-in-out');

document.body.appendChild(splashScreen);

function displaySplashScreen(imgURL, soundURL, time) {
	splashScreen.style.display = 'block';
	splashScreen.style.top = '0';
	splashScreen.style.opacity = '1';
	splashScreen.style.backgroundImage = 'url("'+ imgURL +'")';
	setTimeout(function(){
		hideSplashScreen();
	}, time);
	new Audio(soundURL).play();
}
function hideSplashScreen() {
	splashScreen.style.transition = 'opacity 1.0s ease-in-out';
	splashScreen.style.WebkitTransition = 'opacity 1.0s ease-in-out';
	splashScreen.style.MozTransition = 'opacity 1.0s ease-in-out';
	splashScreen.style.opacity = '0';
	setTimeout(function(){
		splashScreen.style.top = '-100vh';
	}, 1000);
}


//------------------------------------------//
//---------- Add tool : Theme --------------//
//------------------------------------------//
var lastTool = document.getElementById('helpsite');
lastTool.insertAdjacentHTML('afterend', '<li id="themeTool" class="gme" tip="Theme On/Off"><img style="opacity:0.4;" src="http://sda-campagne.fr/misc/palette.png"><div class="submenu"><ul><li id="themeDefault">Theme: Roll20</li><li id="themeStrahd">Theme: D&D Strahd</li><li id="themeGreek">Theme: Greek Myth</li></ul></div></li>');

var favIconLink = document.querySelector("link[rel*='icon']") || createCustomElement('link');
favIconLink.type = 'image/x-icon';
favIconLink.rel = 'shortcut icon';
favIconLink.href = 'http://sda-campagne.fr/misc/favicon_roll20.png';
document.getElementsByTagName('head')[0].appendChild(favIconLink);

const themeList = ['theme-strahd', 'theme-greek'];

function unsetTheme() {
	document.body.classList.remove(...themeList);
}
function setThemeStrahd(rollback) {
	localStorage.setItem('theme', 'stradh');
	displaySplashScreen('http://sda-campagne.fr/misc/castle.jpg', 'http://sda-campagne.fr/misc/wolf_wind.mp3', 5500);
	setTimeout(function(){
		setTheme('theme-strahd', rollback);
	}, 3500);
}
function setThemeGreek(rollback) {
	localStorage.setItem('theme', 'greek');

	displaySplashScreen('http://sda-campagne.fr/misc/greek_screen.jpg', 'http://sda-campagne.fr/misc/intro-sound-greek.mp3', 7000);
	setTimeout(function(){
		setTheme('theme-greek', rollback);
	}, 3500);
}
function setTheme(theme, rollback) {
	document.body.classList.remove(...themeList);
	document.body.classList.add(theme);
	rollback();
}
var themeDefault = document.getElementById('themeDefault');
themeDefault.addEventListener('click', unsetTheme, false);
var themeStrahd = document.getElementById('themeStrahd');
themeStrahd.addEventListener('click', setThemeStrahd, false);
var themeGreek = document.getElementById('themeGreek');
themeGreek.addEventListener('click', setThemeGreek, false);

// listen loading overlay to set theme upon loading end
waitElementExist('loading-overlay', initTheme);
function initTheme() {
		console.log('THEME: initTheme');
	var loadingRollback = () => {
		blackScreen.style.display = 'none';
	};
	var isLoaded = document.getElementById('loading-overlay').style.display === 'none';
	if(isLoaded) {
		console.log('THEME: already loaded -> set Theme');
		setThemeGreek(loadingRollback);
	} else {
		var observerLoading = new MutationObserver(function (mutationsList) {
			for(var mutation of mutationsList) {
				var e = mutation.target;
				if (e.style.display == 'none') {
					console.log('THEME: loading-overlay hidden');
					if(isLoaded) {
						return;
					}
					isLoaded = true;
					console.log('THEME: set Theme');
					setThemeGreek(loadingRollback);
				}
			}
		});
		observerLoading.observe(document.getElementById('loading-overlay'), {
			attributes: true,
			attributeOldValue: false,
			attributeFilter: ['style'],
			characterData: false,
			characterDataOldValue: false,
			childList: false,
			subtree: false
		});
	}
	var blackScreen = createCustomElement('div');
	blackScreen.id = 'blackScreen';
	blackScreen.style.position = 'fixed';
	blackScreen.style.top = '0';
	blackScreen.style.left = '0';
	blackScreen.style.width = '100%';
	blackScreen.style.height = '100%';
	blackScreen.style.zIndex = '99998';
	blackScreen.style.backgroundColor = '#18191b';
	document.body.appendChild(blackScreen);
}

//---------------------------------------------//
//------- Identify initiative panel -----------//
//---------------------------------------------//

// observe initiative panel adding
var initiativePanelObserver = new MutationObserver(function (mutationsList) {
	for(var mutation of mutationsList) {
		if (mutation.type == 'childList') {
			// parse added node
			for (var node of mutation.addedNodes) {
				if (node.nodeType === Node.ELEMENT_NODE) {
					if (node.className.indexOf('ui-dialog') >= 0) {
						// this is the initiative panel opening
						for (var child of node.childNodes) {
							if(child.id === 'initiativewindow') {
								node.id = 'initiativedialog';
							}
						}
					}
				}
			}
		}
	}
});
initiativePanelObserver.observe(document.body, {
	childList: true
});


//------------------------------------------//
//---------- build deco custom -------------//
//------------------------------------------//
var decoLeft = createCustomElement('div');
decoLeft.id = 'editor-deco-left';
document.body.appendChild(decoLeft);
var decoLeft2 = createCustomElement('div');
decoLeft2.id = 'editor-deco-left-2';
document.body.appendChild(decoLeft2);
var decoRight = createCustomElement('div');
decoRight.id = 'editor-deco-right';
document.body.appendChild(decoRight);
var decoRight2 = createCustomElement('div');
decoRight2.id = 'editor-deco-right-2';
document.body.appendChild(decoRight2);
var circleContainer = createCustomElement('div');
circleContainer.id = 'circle-container';
circleContainer.style.opacity = 0;
document.body.appendChild(circleContainer);
var circleView = createCustomElement('div');
circleView.id = 'circle-view';
circleContainer.appendChild(circleView);
var wideView = createCustomElement('img');
wideView.id = 'wide-view';
wideView.style.opacity = 0;
document.body.appendChild(wideView);


var detailsCustom = createCustomElement('div');
detailsCustom.id = 'details-custom';
document.body.appendChild(detailsCustom);
var detailsImg = createCustomElement('div');
detailsImg.id = 'details-img';
detailsImg.style.backgroundSize = 'cover';
detailsImg.style.backgroundPosition = 'top center';
detailsCustom.appendChild(detailsImg);
var detailsTitle = createCustomElement('div');
detailsTitle.id = 'details-title';
detailsCustom.appendChild(detailsTitle);
var detailsTxt = createCustomElement('div');
detailsTxt.id = 'details-txt';
detailsCustom.appendChild(detailsTxt);
function displayDetailsData(cardData) {
	if(cardData.type === 'Personnages') {
		for(var pj of gameData.players) {
			if(pj.nom === cardData.title) {
				setCurrentPJ(pj);
				displayCharSheets();
			}
		};
	} else {
		if(cardData.img) {
			detailsImg.style.backgroundImage = 'url("'+cardData.img+'")';
		} else {
			detailsImg.style.backgroundImage = 'url("http://www.sda-campagne.fr/misc/greek_theme/data/default_card.jpg")';
		}
		detailsTitle.innerHTML = cardData.title;
		detailsTxt.innerHTML = cardData.desc;
	}
}
function displayDetails(detailsId) {
	var details = localStorage.getItem("details");
	console.log('displayDetails: ' + details);
	if (details) {
		console.log('parse data...');
		details = JSON.parse(details);
		for (var data of details) {
			if(data.id === detailsId) {
				console.log('parse res: ' + data);
				displayDetailsData(data);
				break;
			}
		}
	} else {
		console.log('no data');
	}
}

//-----------------------------------------------//
//------- Custom: dice roll animation -----------//
//-----------------------------------------------//
var observer = new MutationObserver(function (mutationsList) {
	var e = document.getElementById('tdviewport');
	if (e.classList.contains('open') && !e.classList.contains('custom')) {
		e.classList.add('custom');
	}
});
var tdviewport = document.getElementById('tdviewport');
observer.observe(tdviewport, {
	attributes: true,
	attributeFilter: ['class'],
	childList: true,
	characterData: true
});
function closeTdviewport(theme) {
	tdviewport.className = '';
}
document.body.addEventListener("click", closeTdviewport, false);

